package application;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Button;

public class FormulaireController {
    
    @FXML
    private Label labelMessage;
    
    @FXML
    private TextField champNom;
    
    @FXML
    private Button btnValider;
    
    @FXML
    private void initialize() {
        // Initialisation : désactiver le bouton au départ
        btnValider.setDisable(true);
        
        // Activer le bouton seulement si le champ n'est pas vide
        champNom.textProperty().addListener((obs, oldVal, newVal) -> {
            btnValider.setDisable(newVal.trim().isEmpty());
        });
    }
    
    @FXML
    private void handleValider() {
        String nom = champNom.getText();
        if (!nom.trim().isEmpty()) {
            labelMessage.setText("Bonjour, " + nom + " !");
            champNom.clear();
        }
    }
}

