# Chapitre 6.1.2 - Gestion avancée d'une liste (ObservableList)

Ce projet Eclipse illustre la gestion avancée d'une ObservableList avec filtrage, tri, suppression conditionnelle et autres opérations avancées, comme présenté dans la section 6.1.2 du cours.

## Description

Ce projet démontre les opérations avancées sur ObservableList :

- **Filtrage en temps réel** : Filtrer la liste selon un critère de recherche
- **Tri** : Trier les éléments par ordre alphabétique
- **Suppression conditionnelle** : Supprimer des éléments selon une condition
- **Opérations en lot** : Ajouter plusieurs éléments en une fois
- **Transformations** : Transformer tous les éléments (majuscules, etc.)
- **Gestion de deux listes** : Liste complète et liste filtrée
- **Listener automatique** : Détection et affichage des changements

## Structure du projet

```
Chapitre6_1_2_GestionAvanceeListe/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée de l'application
│   │   ├── MainController.java          # Contrôleur avec gestion avancée
│   │   ├── main.fxml                   # Interface de l'application
│   │   └── style.css                   # Fichier de styles CSS
│   └── module-info.java                # Configuration du module Java
├── .project                            # Configuration Eclipse
└── .classpath                          # Configuration du classpath
```

## Fonctionnalités

### 1. Gestion de deux listes
- **itemsComplets** : Liste complète contenant tous les éléments
- **items** : Liste filtrée affichée dans la ListView
- Synchronisation automatique entre les deux listes

### 2. Ajout d'éléments
- **Ajouter** : Ajoute un élément à la liste complète
- **Ajouter plusieurs** : Utilise `addAll()` pour ajouter plusieurs éléments en une fois
- Filtrage automatique : Les nouveaux éléments sont ajoutés à la liste affichée s'ils correspondent au filtre

### 3. Suppression d'éléments
- **Supprimer sélectionné** : Supprime l'élément sélectionné des deux listes
- **Supprimer conditionnel** : Utilise `removeIf()` pour supprimer les éléments de moins de 5 caractères
- **Vider** : Vide complètement les deux listes avec `clear()`

### 4. Filtrage
- **Filtrage en temps réel** : Le filtre s'applique automatiquement quand vous tapez dans le champ de recherche
- **Filtrage manuel** : Bouton "Filtrer" pour appliquer le filtre
- Utilise `setAll()` avec un stream filtré pour mettre à jour la liste affichée

### 5. Tri
- **Trier** : Trie les éléments par ordre alphabétique avec `FXCollections.sort()`
- Trie à la fois la liste complète et la liste filtrée

### 6. Opérations avancées
- **Supprimer doublons** : Utilise `distinct()` pour supprimer les doublons
- **Remplacer tout** : Utilise `setAll()` pour remplacer complètement le contenu
- **Majuscules** : Utilise `replaceAll()` pour transformer tous les éléments en majuscules
- **Réinitialiser** : Remet la liste à son état initial

### 7. Listener et compteur
- **ListChangeListener** : Écoute tous les changements dans la liste
- **Compteur automatique** : Affiche le nombre d'éléments affichés / total
- **Messages** : Affiche des messages selon le type d'opération

## Comment utiliser

1. **Ouvrir le projet dans Eclipse** :
   - File → Open Projects from File System
   - Sélectionner le dossier `Chapitre6_1_2_GestionAvanceeListe`

2. **Configurer JavaFX** :
   - Assurez-vous que JavaFX SDK est configuré dans Eclipse
   - Le projet utilise JavaFX 25 (modifiable dans `.classpath`)

3. **Exécuter l'application** :
   - Clic droit sur `Main.java`
   - Run As → Java Application

4. **Tester les fonctionnalités** :
   - **Ajouter** : Saisissez un élément et cliquez sur "Ajouter"
   - **Filtrer** : Tapez dans le champ de recherche (filtrage automatique)
   - **Trier** : Cliquez sur "Trier" pour trier par ordre alphabétique
   - **Supprimer conditionnel** : Cliquez pour supprimer les éléments courts
   - **Majuscules** : Transforme tous les éléments en majuscules
   - **Ajouter plusieurs** : Ajoute 3 éléments en une seule opération
   - **Supprimer doublons** : Supprime les éléments en double
   - **Réinitialiser** : Remet la liste à son état initial

## Points clés à retenir

### Gestion de deux listes
```java
// Liste complète (tous les éléments)
private ObservableList<String> itemsComplets;

// Liste filtrée (affichée)
private ObservableList<String> items;

// Synchronisation
items.setAll(itemsComplets); // Copier tous les éléments
```

### Filtrage avec Stream
```java
// Filtrer selon un critère
items.setAll(
    itemsComplets.stream()
        .filter(item -> item.toLowerCase().contains(recherche))
        .collect(Collectors.toList())
);
```

### Suppression conditionnelle
```java
// Supprimer tous les éléments qui correspondent à une condition
itemsComplets.removeIf(element -> element.length() < 5);
```

### Transformation avec replaceAll
```java
// Transformer tous les éléments
itemsComplets.replaceAll(element -> element.toUpperCase());
```

### Opérations en lot
```java
// Ajouter plusieurs éléments en une fois
itemsComplets.addAll("Élément 1", "Élément 2", "Élément 3");

// Remplacer tout le contenu (plus efficace que clear + addAll)
itemsComplets.setAll("Nouveau 1", "Nouveau 2", "Nouveau 3");
```

## Méthodes utilisées

| Méthode | Description | Utilisation dans le projet |
|---------|-------------|---------------------------|
| `add()` | Ajouter un élément | Ajout d'un nouvel élément |
| `addAll()` | Ajouter plusieurs éléments | Ajout de plusieurs éléments en une fois |
| `remove()` | Supprimer un élément | Suppression de l'élément sélectionné |
| `removeIf()` | Supprimer conditionnellement | Suppression des éléments courts |
| `clear()` | Vider la liste | Vider complètement |
| `setAll()` | Remplacer tout | Filtrage et remplacement |
| `replaceAll()` | Transformer tous | Mise en majuscules |
| `distinct()` | Supprimer doublons | Nettoyage de la liste |
| `sort()` | Trier | Tri alphabétique |

## Différences importantes

### setAll() vs clear() + addAll()
```java
// ❌ Moins efficace (2 notifications)
items.clear();
items.addAll(nouveauxElements);

// ✅ Plus efficace (1 notification)
items.setAll(nouveauxElements);
```

### Filtrage avec deux listes
- **Liste complète** : Contient tous les éléments (source de données)
- **Liste filtrée** : Contient seulement les éléments affichés (vue)
- Avantage : Vous gardez tous les éléments même après filtrage

## Styles CSS

Le fichier `style.css` contient :
- `.message-success` : Texte vert pour les messages de succès
- `.message-warning` : Texte orange pour les messages d'avertissement
- `.message-error` : Texte rouge pour les messages d'erreur
- Styles pour les boutons avec effet hover
- Styles pour les TextField et ListView

## Notes importantes

- ✅ **Deux listes** : Utilisez une liste complète et une liste filtrée pour le filtrage
- ✅ **setAll()** : Plus efficace que clear() + addAll() pour remplacer
- ✅ **removeIf()** : Optimisé pour les suppressions conditionnelles
- ✅ **Stream API** : Utilisez les streams pour le filtrage et les transformations
- ✅ **Listener** : Écoutez les changements pour mettre à jour les compteurs et messages
- ✅ **Filtrage automatique** : Le filtre s'applique en temps réel grâce au listener sur le TextField

## Cas d'usage

Ce projet illustre des cas d'usage réels :
- **Liste de produits** : Filtrer, trier, gérer les produits
- **Liste de contacts** : Rechercher, ajouter, supprimer des contacts
- **Liste de tâches** : Filtrer par statut, trier par priorité
- **Gestion de données** : Nettoyer, transformer, organiser des données

## Compatibilité

- JavaFX 17+
- Java 11+
- Compatible avec Windows, macOS et Linux

