# Chapitre 6.2.1 - ListView : Affichage et sélection

Ce projet Eclipse illustre l'affichage et la sélection dans une ListView JavaFX, comme présenté dans la section 6.2.1 du cours.

## Description

Ce projet démontre les fonctionnalités de base d'une ListView :

- **Affichage d'éléments** : Liste d'éléments String affichée dans une ListView
- **Sélection simple** : Sélectionner un élément dans la liste
- **Sélection multiple** : Sélectionner plusieurs éléments (Ctrl/Cmd + clic)
- **Gestion de la sélection** : Récupérer l'élément sélectionné, l'index, etc.
- **Écouter les changements** : Listener sur les changements de sélection
- **Contrôles de sélection** : Sélectionner le premier, suivant, précédent, effacer

## Structure du projet

```
Chapitre6_2_1_AffichageSelection/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée
│   │   ├── MainController.java          # Contrôleur avec gestion de sélection
│   │   ├── main.fxml                   # Interface utilisateur
│   │   └── style.css                   # Styles CSS
│   └── module-info.java                # Configuration du module
├── .project                            # Configuration Eclipse
└── .classpath                          # Configuration du classpath
```

## Fonctionnalités

### 1. Affichage de la liste
- Liste d'éléments String (fruits)
- ObservableList liée à la ListView avec `setItems()`
- Mise à jour automatique quand la liste change

### 2. Sélection
- **Sélection simple** : Cliquer sur un élément pour le sélectionner
- **Sélection multiple** : Maintenir Ctrl (ou Cmd) et cliquer pour sélectionner plusieurs éléments
- **Affichage de la sélection** : Label qui affiche l'élément sélectionné
- **Index** : Affiche l'index de l'élément sélectionné
- **Nombre de sélections** : Affiche le nombre d'éléments sélectionnés

### 3. Contrôles
- **Ajouter** : Ajouter un nouvel élément à la liste
- **Supprimer** : Supprimer l'élément sélectionné
- **Afficher** : Afficher les éléments sélectionnés dans la console
- **Premier** : Sélectionner le premier élément
- **Précédent** : Sélectionner l'élément précédent
- **Suivant** : Sélectionner l'élément suivant
- **Effacer** : Désélectionner tout

### 4. Listener de sélection
- Écoute les changements de sélection automatiquement
- Met à jour les labels en temps réel
- Détecte les sélections simples et multiples

## Comment utiliser

1. **Ouvrir le projet dans Eclipse**
2. **Exécuter** : Run As → Java Application
3. **Tester** :
   - Cliquer sur un élément pour le sélectionner
   - Maintenir Ctrl et cliquer pour sélectionner plusieurs éléments
   - Utiliser les boutons pour contrôler la sélection
   - Ajouter/supprimer des éléments

## Points clés

- `setItems()` : Lie une ObservableList à la ListView
- `getSelectionModel()` : Accède au modèle de sélection
- `getSelectedItem()` : Récupère l'élément sélectionné
- `getSelectedItems()` : Récupère tous les éléments sélectionnés (sélection multiple)
- `selectedItemProperty()` : Propriété observable pour écouter les changements
- `setSelectionMode(SelectionMode.MULTIPLE)` : Active la sélection multiple

