package application;

import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.SelectionMode;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MainController {
	
	@FXML
	private ListView<String> listViewItems;
	
	@FXML
	private TextField txtNouvelItem;
	
	@FXML
	private Button btnAjouter;
	
	@FXML
	private Button btnSupprimer;
	
	@FXML
	private Button btnAfficherSelection;
	
	@FXML
	private Button btnSelectionnerPremier;
	
	@FXML
	private Button btnClearSelection;
	
	@FXML
	private Label lblSelection;
	
	@FXML
	private Label lblIndex;
	
	@FXML
	private Label lblNombreSelections;
	
	private ObservableList<String> items;
	
	@FXML
	private void initialize() {
		// Créer l'ObservableList avec des éléments initiaux
		items = FXCollections.observableArrayList(
			"Pomme", "Banane", "Orange", "Fraise", "Cerise", "Kiwi", "Mangue"
		);
		
		// Lier la ListView à l'ObservableList
		listViewItems.setItems(items);
		
		// Activer la sélection multiple
		listViewItems.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
		
		// Écouter les changements de sélection
		listViewItems.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
			if (newVal != null) {
				lblSelection.setText("Sélectionné : " + newVal);
				int index = listViewItems.getSelectionModel().getSelectedIndex();
				lblIndex.setText("Index : " + index);
			} else {
				lblSelection.setText("Aucune sélection");
				lblIndex.setText("Index : -");
			}
			
			// Mettre à jour le nombre de sélections
			updateNombreSelections();
		});
		
		// Initialiser les labels
		lblSelection.setText("Aucune sélection");
		lblIndex.setText("Index : -");
		updateNombreSelections();
	}
	
	private void updateNombreSelections() {
		int count = listViewItems.getSelectionModel().getSelectedItems().size();
		lblNombreSelections.setText("Nombre de sélections : " + count);
	}
	
	@FXML
	private void ajouterItem() {
		String nouvelItem = txtNouvelItem.getText().trim();
		if (!nouvelItem.isEmpty()) {
			items.add(nouvelItem);
			txtNouvelItem.clear();
		}
	}
	
	@FXML
	private void supprimerItem() {
		String selectionne = listViewItems.getSelectionModel().getSelectedItem();
		if (selectionne != null) {
			items.remove(selectionne);
		}
	}
	
	@FXML
	private void afficherSelection() {
		ObservableList<String> selections = listViewItems.getSelectionModel().getSelectedItems();
		if (!selections.isEmpty()) {
			System.out.println("Éléments sélectionnés : " + selections);
			System.out.println("Nombre : " + selections.size());
		} else {
			System.out.println("Aucun élément sélectionné");
		}
	}
	
	@FXML
	private void selectionnerPremier() {
		if (!items.isEmpty()) {
			listViewItems.getSelectionModel().select(0);
		}
	}
	
	@FXML
	private void clearSelection() {
		listViewItems.getSelectionModel().clearSelection();
	}
	
	@FXML
	private void selectionnerSuivant() {
		listViewItems.getSelectionModel().selectNext();
	}
	
	@FXML
	private void selectionnerPrecedent() {
		listViewItems.getSelectionModel().selectPrevious();
	}
}

