# Chapitre 6.2.2 - ListView : Liaison à un modèle simple

Ce projet Eclipse illustre la liaison d'une ListView à un modèle de données personnalisé (classe Personne), comme présenté dans la section 6.2.2 du cours.

## Description

Ce projet démontre comment utiliser une ListView avec un modèle personnalisé :

- **Modèle Personne** : Classe personnalisée avec nom, prénom et âge
- **toString()** : Méthode utilisée par la ListView pour afficher chaque élément
- **ObservableList&lt;Personne&gt;** : Liste observable de Personne
- **Récupération des données** : Accéder aux propriétés de l'objet sélectionné
- **Modification** : Modifier les propriétés et utiliser refresh() pour mettre à jour

## Structure du projet

```
Chapitre6_2_2_LiaisonModele/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée
│   │   ├── MainController.java          # Contrôleur avec gestion du modèle
│   │   ├── Personne.java                # Classe modèle Personne
│   │   ├── main.fxml                   # Interface utilisateur
│   │   └── style.css                   # Styles CSS
│   └── module-info.java                # Configuration du module
├── .project                            # Configuration Eclipse
└── .classpath                          # Configuration du classpath
```

## Fonctionnalités

### 1. Classe Personne
- Propriétés : nom, prénom, âge
- Méthode `toString()` : Utilisée par la ListView pour l'affichage
- Getters et setters pour toutes les propriétés

### 2. ListView avec modèle
- `ListView<Personne>` : ListView qui affiche des objets Personne
- `ObservableList<Personne>` : Liste observable de Personne
- Affichage automatique via `toString()`

### 3. Sélection et affichage
- Sélectionner une personne dans la ListView
- Afficher les détails (nom, prénom, âge)
- Remplir automatiquement les champs de texte

### 4. Opérations
- **Ajouter** : Créer et ajouter une nouvelle personne
- **Modifier** : Modifier les propriétés d'une personne sélectionnée
- **Supprimer** : Supprimer une personne de la liste

### 5. Refresh
- Utilisation de `listView.refresh()` après modification
- Nécessaire car la ListView ne détecte pas les changements de propriétés automatiquement
- (Voir section 6.1.3 pour l'extractor qui permet une mise à jour automatique)

## Comment utiliser

1. **Ouvrir le projet dans Eclipse**
2. **Exécuter** : Run As → Java Application
3. **Tester** :
   - Sélectionner une personne dans la liste
   - Voir les détails s'afficher
   - Modifier les champs et cliquer sur "Modifier"
   - Observer que `refresh()` est nécessaire pour voir les changements
   - Ajouter une nouvelle personne

## Points clés

- **Modèle personnalisé** : Créez une classe pour représenter vos données
- **toString()** : Redéfinissez cette méthode pour l'affichage dans la ListView
- **ObservableList&lt;Type&gt;** : Utilisez le type de votre modèle
- **getSelectedItem()** : Retourne l'objet complet, pas juste une String
- **refresh()** : Nécessaire si vous modifiez les propriétés d'un objet
- **Extractor** : Pour une mise à jour automatique (voir section 6.1.3)

## Différence avec String

| Aspect | String | Modèle personnalisé |
|--------|--------|---------------------|
| Affichage | Direct | Via toString() |
| Données | Une seule valeur | Plusieurs propriétés |
| Accès | Direct | Via getters |
| Modification | Simple | Nécessite refresh() |

