package application;

import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MainController {
	
	@FXML
	private ListView<Personne> listViewPersonnes;
	
	@FXML
	private TextField txtNom;
	
	@FXML
	private TextField txtPrenom;
	
	@FXML
	private TextField txtAge;
	
	@FXML
	private Button btnAjouter;
	
	@FXML
	private Button btnModifier;
	
	@FXML
	private Button btnSupprimer;
	
	@FXML
	private Label lblDetails;
	
	private ObservableList<Personne> personnes;
	
	@FXML
	private void initialize() {
		// Créer l'ObservableList de Personne
		personnes = FXCollections.observableArrayList(
			new Personne("Dupont", "Jean", 25),
			new Personne("Martin", "Marie", 30),
			new Personne("Bernard", "Pierre", 28),
			new Personne("Dubois", "Sophie", 32),
			new Personne("Lefebvre", "Thomas", 26)
		);
		
		// Lier à la ListView
		listViewPersonnes.setItems(personnes);
		
		// Écouter les changements de sélection
		listViewPersonnes.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
			if (newVal != null) {
				// Afficher les détails de la personne sélectionnée
				String details = String.format("Nom : %s\nPrénom : %s\nÂge : %d ans",
					newVal.getNom(), newVal.getPrenom(), newVal.getAge());
				lblDetails.setText(details);
				
				// Remplir les champs de texte
				txtNom.setText(newVal.getNom());
				txtPrenom.setText(newVal.getPrenom());
				txtAge.setText(String.valueOf(newVal.getAge()));
			} else {
				lblDetails.setText("Aucune personne sélectionnée");
				txtNom.clear();
				txtPrenom.clear();
				txtAge.clear();
			}
		});
		
		// Initialiser le label
		lblDetails.setText("Aucune personne sélectionnée");
	}
	
	@FXML
	private void ajouterPersonne() {
		try {
			String nom = txtNom.getText().trim();
			String prenom = txtPrenom.getText().trim();
			int age = Integer.parseInt(txtAge.getText().trim());
			
			if (nom.isEmpty() || prenom.isEmpty()) {
				lblDetails.setText("Erreur : Veuillez remplir le nom et le prénom");
				return;
			}
			
			Personne nouvelle = new Personne(nom, prenom, age);
			personnes.add(nouvelle);
			
			// Sélectionner automatiquement la nouvelle personne
			listViewPersonnes.getSelectionModel().select(nouvelle);
			
			lblDetails.setText("Personne ajoutée : " + nouvelle);
		} catch (NumberFormatException e) {
			lblDetails.setText("Erreur : Âge invalide");
		}
	}
	
	@FXML
	private void modifierPersonne() {
		Personne selectionnee = listViewPersonnes.getSelectionModel().getSelectedItem();
		
		if (selectionnee == null) {
			lblDetails.setText("Veuillez sélectionner une personne à modifier");
			return;
		}
		
		try {
			String nom = txtNom.getText().trim();
			String prenom = txtPrenom.getText().trim();
			int age = Integer.parseInt(txtAge.getText().trim());
			
			// Modifier les propriétés
			selectionnee.setNom(nom);
			selectionnee.setPrenom(prenom);
			selectionnee.setAge(age);
			
			// Pour que la ListView se mette à jour, il faut appeler refresh()
			// (sauf si vous utilisez un extractor - voir section 6.1.3)
			listViewPersonnes.refresh();
			
			lblDetails.setText("Personne modifiée : " + selectionnee);
		} catch (NumberFormatException e) {
			lblDetails.setText("Erreur : Âge invalide");
		}
	}
	
	@FXML
	private void supprimerPersonne() {
		Personne selectionnee = listViewPersonnes.getSelectionModel().getSelectedItem();
		
		if (selectionnee != null) {
			personnes.remove(selectionnee);
			lblDetails.setText("Personne supprimée");
		} else {
			lblDetails.setText("Veuillez sélectionner une personne à supprimer");
		}
	}
}

