# Chapitre 6.2.3 - ListView : CellFactory simple (optionnel)

Ce projet Eclipse illustre l'utilisation d'une CellFactory pour personnaliser l'affichage dans une ListView JavaFX, comme présenté dans la section 6.2.3 du cours.

## Description

Ce projet démontre comment personnaliser l'affichage des cellules dans une ListView :

- **CellFactory simple** : Personnalisation avec styles conditionnels pour String
- **CellFactory avec objets** : Personnalisation avec HBox et plusieurs Labels pour Personne
- **Styles conditionnels** : Appliquer des styles selon les propriétés des éléments
- **Affichage personnalisé** : Utiliser setGraphic() pour un contenu complexe

## Structure du projet

```
Chapitre6_2_3_CellFactory/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée
│   │   ├── MainController.java          # Contrôleur avec CellFactory
│   │   ├── Personne.java                # Classe modèle Personne
│   │   ├── main.fxml                   # Interface utilisateur
│   │   └── style.css                   # Styles CSS
│   └── module-info.java                # Configuration du module
├── .project                            # Configuration Eclipse
└── .classpath                          # Configuration du classpath
```

## Fonctionnalités

### 1. Exemple 1 : CellFactory simple avec String
- ListView de String avec styles conditionnels
- Styles différents selon la première lettre :
  - P (Pomme) : Rouge, gras, fond rose clair
  - B (Banane) : Jaune, gras, fond jaune clair
  - O (Orange) : Orange, gras, fond orange clair
  - Autres : Bleu, fond bleu clair

### 2. Exemple 2 : CellFactory avec objets Personne
- ListView de Personne avec affichage personnalisé
- HBox contenant plusieurs Labels :
  - Label pour le nom (gras)
  - Label pour l'âge (gris)
- Styles conditionnels selon l'âge :
  - < 25 ans : Fond bleu clair
  - < 30 ans : Fond violet clair
  - ≥ 30 ans : Fond orange clair

### 3. Méthodes importantes
- `setCellFactory()` : Définit la CellFactory
- `updateItem()` : Méthode appelée pour chaque cellule
- `setText()` : Pour un affichage texte simple
- `setGraphic()` : Pour un affichage personnalisé (HBox, VBox, etc.)
- `empty` : Vérifier si la cellule est vide

## Comment utiliser

1. **Ouvrir le projet dans Eclipse**
2. **Exécuter** : Run As → Java Application
3. **Observer** :
   - Les styles différents dans la première ListView
   - L'affichage personnalisé dans la deuxième ListView
   - Les couleurs de fond selon les critères

## Points clés

- **CellFactory** : Permet de personnaliser l'affichage de chaque cellule
- **updateItem()** : Toujours appeler `super.updateItem()` en premier
- **Vérifications** : Toujours vérifier `empty` et `null`
- **setText() vs setGraphic()** : Utilisez setGraphic() pour un contenu complexe
- **Optionnel** : Utilisez seulement si vous avez besoin de personnalisation

## Quand utiliser une CellFactory ?

- ✅ Personnaliser l'apparence (couleurs, polices)
- ✅ Ajouter des icônes ou images
- ✅ Mise en forme avancée avec plusieurs composants
- ✅ Affichage conditionnel selon les propriétés

## Quand ne pas utiliser ?

- ❌ Affichage simple avec toString() suffit
- ❌ Pas besoin de personnalisation
- ❌ Complexité inutile

## Code clé

```java
listView.setCellFactory(listView -> new ListCell<Type>() {
    @Override
    protected void updateItem(Type item, boolean empty) {
        super.updateItem(item, empty);
        
        if (empty || item == null) {
            setText(null);
            setGraphic(null);
        } else {
            // Personnaliser l'affichage
            setText(item.toString());
            // ou
            setGraphic(monHBoxPersonnalise);
        }
    }
});
```

