package application;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MainController {
	
	@FXML
	private ListView<String> listViewSimple;
	
	@FXML
	private ListView<Personne> listViewPersonnes;
	
	private ObservableList<String> items;
	private ObservableList<Personne> personnes;
	
	@FXML
	private void initialize() {
		// ============================================
		// Exemple 1 : CellFactory simple avec String
		// ============================================
		items = FXCollections.observableArrayList(
			"Pomme", "Banane", "Orange", "Fraise", "Cerise", "Kiwi"
		);
		
		listViewSimple.setItems(items);
		
		// CellFactory avec styles conditionnels
		listViewSimple.setCellFactory(listView -> new ListCell<String>() {
			@Override
			protected void updateItem(String item, boolean empty) {
				super.updateItem(item, empty);
				
				if (empty || item == null) {
					setText(null);
					setStyle("");
				} else {
					setText(item);
					
					// Appliquer des styles selon l'élément
					if (item.startsWith("P")) {
						setStyle("-fx-text-fill: red; -fx-font-weight: bold; -fx-background-color: #ffebee;");
					} else if (item.startsWith("B")) {
						setStyle("-fx-text-fill: #f57f17; -fx-font-weight: bold; -fx-background-color: #fffde7;");
					} else if (item.startsWith("O")) {
						setStyle("-fx-text-fill: #e65100; -fx-font-weight: bold; -fx-background-color: #fff3e0;");
					} else {
						setStyle("-fx-text-fill: blue; -fx-background-color: #e3f2fd;");
					}
				}
			}
		});
		
		// ============================================
		// Exemple 2 : CellFactory avec objets Personne
		// ============================================
		personnes = FXCollections.observableArrayList(
			new Personne("Dupont", "Jean", 25),
			new Personne("Martin", "Marie", 30),
			new Personne("Bernard", "Pierre", 28),
			new Personne("Dubois", "Sophie", 32),
			new Personne("Lefebvre", "Thomas", 26)
		);
		
		listViewPersonnes.setItems(personnes);
		
		// CellFactory pour Personne avec HBox personnalisé
		listViewPersonnes.setCellFactory(listView -> new ListCell<Personne>() {
			@Override
			protected void updateItem(Personne personne, boolean empty) {
				super.updateItem(personne, empty);
				
				if (empty || personne == null) {
					setText(null);
					setGraphic(null);
					setStyle("");
				} else {
					// Créer un HBox avec plusieurs Labels
					HBox hbox = new HBox(10);
					hbox.setStyle("-fx-padding: 5px;");
					
					Label lblNom = new Label(personne.getPrenom() + " " + personne.getNom());
					lblNom.setStyle("-fx-font-weight: bold; -fx-font-size: 14px;");
					
					Label lblAge = new Label("(" + personne.getAge() + " ans)");
					lblAge.setStyle("-fx-text-fill: gray; -fx-font-size: 12px;");
					
					// Style selon l'âge
					if (personne.getAge() < 25) {
						hbox.setStyle("-fx-background-color: #e3f2fd; -fx-padding: 5px; -fx-background-radius: 3px;");
					} else if (personne.getAge() < 30) {
						hbox.setStyle("-fx-background-color: #f3e5f5; -fx-padding: 5px; -fx-background-radius: 3px;");
					} else {
						hbox.setStyle("-fx-background-color: #fff3e0; -fx-padding: 5px; -fx-background-radius: 3px;");
					}
					
					hbox.getChildren().addAll(lblNom, lblAge);
					setGraphic(hbox);
				}
			}
		});
	}
}

