# Chapitre 6.3.1 - TableView : Structure : colonnes, lignes, modèle

Ce projet Eclipse illustre la structure de base d'un TableView JavaFX avec colonnes, lignes et modèle, comme présenté dans la section 6.3.1 du cours.

## Description

Ce projet démontre la structure de base d'un TableView :

- **Structure TableView** : Création d'un tableau avec colonnes et lignes
- **Modèle Personne** : Classe modèle simple avec nom, prénom, âge, email
- **TableColumn** : Création de colonnes pour chaque propriété
- **Liaison manuelle** : Utilisation de setCellValueFactory() manuellement
- **ObservableList** : Liste observable liée au TableView

## Structure du projet

```
Chapitre6_3_1_StructureTableView/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée
│   │   ├── MainController.java          # Contrôleur avec TableView
│   │   ├── Personne.java                # Classe modèle Personne
│   │   ├── main.fxml                   # Interface utilisateur
│   │   └── style.css                   # Styles CSS
│   └── module-info.java                # Configuration du module
├── .project                            # Configuration Eclipse
└── .classpath                          # Configuration du classpath
```

## Fonctionnalités

### 1. Classe Personne
- Propriétés : nom, prénom, âge, email
- Getters et setters pour toutes les propriétés
- Modèle simple (sans propriétés observables)

### 2. TableView avec colonnes
- **colNom** : Colonne pour le nom
- **colPrenom** : Colonne pour le prénom
- **colAge** : Colonne pour l'âge (Integer)
- **colEmail** : Colonne pour l'email

### 3. Liaison manuelle
- Utilisation de setCellValueFactory() avec lambda
- Conversion manuelle en SimpleStringProperty et SimpleIntegerProperty
- Pour Integer, utilisation de .asObject()

### 4. Sélection
- Écoute des changements de sélection
- Affichage des informations de la personne sélectionnée

## Comment utiliser

1. **Ouvrir le projet dans Eclipse**
2. **Exécuter** : Run As → Java Application
3. **Observer** :
   - Le tableau avec 4 colonnes
   - Les 5 personnes affichées
   - La sélection d'une ligne

## Points clés

- **TableView&lt;Personne&gt;** : TableView qui affiche des objets Personne
- **TableColumn&lt;Personne, String&gt;** : Colonne pour une propriété String
- **setCellValueFactory()** : Définit comment obtenir la valeur à afficher
- **setItems()** : Lie l'ObservableList au TableView
- **.asObject()** : Nécessaire pour convertir int en Integer

## Prochaines étapes

Dans les sections suivantes, vous apprendrez :
- PropertyValueFactory pour simplifier la liaison
- Propriétés observables pour la mise à jour automatique
- Édition de cellule pour modifier directement dans le tableau

