# Chapitre 6.3.2 - TableView : PropertyValueFactory

Ce projet Eclipse illustre l'utilisation de PropertyValueFactory pour simplifier la liaison des colonnes aux propriétés dans un TableView JavaFX, comme présenté dans la section 6.3.2 du cours.

## Description

Ce projet démontre l'utilisation de PropertyValueFactory :

- **PropertyValueFactory** : Simplifie la liaison des colonnes aux propriétés
- **Convention JavaBean** : Utilise automatiquement les getters (getNom, getAge, etc.)
- **Code simplifié** : Moins de code que la méthode manuelle
- **Méthode standard** : Méthode recommandée pour la plupart des cas

## Structure du projet

```
Chapitre6_3_2_PropertyValueFactory/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée
│   │   ├── MainController.java          # Contrôleur avec PropertyValueFactory
│   │   ├── Personne.java                # Classe modèle Personne
│   │   ├── main.fxml                   # Interface utilisateur
│   │   └── style.css                   # Styles CSS
│   └── module-info.java                # Configuration du module
├── .project                            # Configuration Eclipse
└── .classpath                          # Configuration du classpath
```

## Fonctionnalités

### 1. PropertyValueFactory
- Utilisation de `new PropertyValueFactory<>("nom")` pour chaque colonne
- Recherche automatique des getters correspondants
- Code beaucoup plus simple que la méthode manuelle

### 2. Convention de nommage
- "nom" → cherche getNom()
- "age" → cherche getAge()
- "email" → cherche getEmail()

### 3. Comparaison avec méthode manuelle
- **Méthode manuelle** : Plus de code, plus complexe
- **PropertyValueFactory** : Moins de code, plus simple, méthode standard

## Comment utiliser

1. **Ouvrir le projet dans Eclipse**
2. **Exécuter** : Run As → Java Application
3. **Observer** :
   - Le même résultat qu'avec la méthode manuelle
   - Mais avec beaucoup moins de code !

## Points clés

- **PropertyValueFactory** : Simplifie la liaison des colonnes
- **Nom de propriété** : Utilisez le nom en minuscule (ex: "nom", pas "Nom")
- **Getters requis** : Les méthodes getter doivent exister
- **Méthode standard** : C'est la méthode recommandée

## Avantages

- ✅ Moins de code
- ✅ Plus simple à maintenir
- ✅ Méthode standard
- ✅ Automatique par nom de propriété

