package application;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MainController {
	
	@FXML
	private TableView<Personne> tableViewPersonnes;
	
	@FXML
	private TableColumn<Personne, String> colNom;
	
	@FXML
	private TableColumn<Personne, String> colPrenom;
	
	@FXML
	private TableColumn<Personne, Integer> colAge;
	
	@FXML
	private TableColumn<Personne, String> colEmail;
	
	@FXML
	private Label lblInfo;
	
	private ObservableList<Personne> personnes;
	
	@FXML
	private void initialize() {
		// Créer les données
		personnes = FXCollections.observableArrayList(
			new Personne("Dupont", "Jean", 25, "jean@exemple.com"),
			new Personne("Martin", "Marie", 30, "marie@exemple.com"),
			new Personne("Bernard", "Pierre", 28, "pierre@exemple.com"),
			new Personne("Dubois", "Sophie", 32, "sophie@exemple.com"),
			new Personne("Lefebvre", "Thomas", 26, "thomas@exemple.com")
		);
		
		// Utiliser PropertyValueFactory pour lier automatiquement
		colNom.setCellValueFactory(new PropertyValueFactory<>("nom"));
		colPrenom.setCellValueFactory(new PropertyValueFactory<>("prenom"));
		colAge.setCellValueFactory(new PropertyValueFactory<>("age"));
		colEmail.setCellValueFactory(new PropertyValueFactory<>("email"));
		
		// Définir les titres des colonnes
		colNom.setText("Nom");
		colPrenom.setText("Prénom");
		colAge.setText("Âge");
		colEmail.setText("Email");
		
		// Lier la liste au TableView
		tableViewPersonnes.setItems(personnes);
		
		// Écouter les changements de sélection
		tableViewPersonnes.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
			if (newVal != null) {
				lblInfo.setText("Sélectionné : " + newVal.getPrenom() + " " + newVal.getNom() + 
				              " (" + newVal.getAge() + " ans) - " + newVal.getEmail());
			} else {
				lblInfo.setText("Aucune sélection");
			}
		});
		
		// Initialiser le label
		lblInfo.setText("Nombre de personnes : " + personnes.size() + " - Utilisez PropertyValueFactory pour simplifier !");
	}
}

