# Chapitre 6.3.3 - TableView : Modèle observable

Ce projet Eclipse illustre l'utilisation d'un TableView avec un modèle utilisant des propriétés observables JavaFX (StringProperty, IntegerProperty, etc.), comme présenté dans la section 6.3.3 du cours.

## Description

Ce projet démontre l'utilisation de propriétés observables dans un modèle pour TableView :

- **Propriétés observables** : Utilisation de StringProperty, IntegerProperty dans la classe Personne
- **Mise à jour automatique** : Le TableView se met à jour automatiquement quand vous modifiez les propriétés
- **Pas de refresh()** : Plus besoin d'appeler refresh() manuellement
- **PropertyValueFactory** : Utilise automatiquement les propriétés observables

## Structure du projet

```
Chapitre6_3_3_ModeleObservable/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée
│   │   ├── MainController.java          # Contrôleur avec TableView
│   │   ├── Personne.java                # Classe modèle avec propriétés observables
│   │   ├── main.fxml                   # Interface utilisateur
│   │   └── style.css                   # Styles CSS
│   └── module-info.java                # Configuration du module
├── .project                            # Configuration Eclipse
└── .classpath                          # Configuration du classpath
```

## Fonctionnalités

### 1. Classe Personne avec propriétés observables
- **StringProperty** : Pour nom, prenom, email
- **IntegerProperty** : Pour age
- **Méthodes Property** : nomProperty(), prenomProperty(), ageProperty(), emailProperty()
- **Getters/Setters** : Méthodes classiques pour compatibilité

### 2. TableView avec PropertyValueFactory
- Utilisation de PropertyValueFactory pour lier automatiquement
- PropertyValueFactory détecte et utilise les propriétés observables
- Mise à jour automatique quand les propriétés changent

### 3. Modification en temps réel
- **Modifier** : Modifie les propriétés de la personne sélectionnée
- **Âge +1** : Augmente l'âge de 1
- **Mise à jour automatique** : Le TableView se met à jour sans refresh()

### 4. Sélection et formulaire
- Sélectionner une personne dans le tableau
- Les champs de texte se remplissent automatiquement
- Modifier les champs et cliquer sur "Modifier"
- Observer la mise à jour automatique dans le tableau

## Comment utiliser

1. **Ouvrir le projet dans Eclipse**
2. **Exécuter** : Run As → Java Application
3. **Tester** :
   - Sélectionner une personne dans le tableau
   - Modifier les champs et cliquer sur "Modifier"
   - Observer que le tableau se met à jour automatiquement
   - Cliquer sur "Âge +1" pour voir la mise à jour en temps réel

## Points clés

- **Propriétés observables** : StringProperty, IntegerProperty au lieu de String, int
- **Méthodes Property** : Créez nomProperty(), ageProperty(), etc.
- **Mise à jour automatique** : Le TableView se met à jour automatiquement
- **Pas de refresh()** : Plus besoin d'appeler refresh() manuellement
- **PropertyValueFactory** : Utilise automatiquement les propriétés observables

## Différence avec modèle simple

| Aspect | Modèle simple | Modèle observable |
|--------|---------------|-------------------|
| Types | String, int | StringProperty, IntegerProperty |
| Mise à jour | Nécessite refresh() | Automatique |
| Complexité | Plus simple | Légèrement plus complexe |
| Performance | Légèrement plus rapide | Légèrement plus lent (négligeable) |
| Recommandation | Données statiques | ✅ Données modifiables |

## Avantages

- ✅ Mise à jour automatique du TableView
- ✅ Pas besoin de refresh()
- ✅ Changements visibles en temps réel
- ✅ Compatible avec PropertyValueFactory
- ✅ Permet le binding avec d'autres composants

## Code clé

### Classe Personne avec propriétés observables
```java
public class Personne {
    private StringProperty nom = new SimpleStringProperty();
    private IntegerProperty age = new SimpleIntegerProperty();
    
    public StringProperty nomProperty() { return nom; }
    public IntegerProperty ageProperty() { return age; }
    
    public String getNom() { return nom.get(); }
    public void setNom(String nom) { this.nom.set(nom); }
}
```

### Modification avec mise à jour automatique
```java
@FXML
private void modifierPersonne() {
    Personne selectionnee = tableViewPersonnes.getSelectionModel().getSelectedItem();
    
    // Modifier les propriétés
    selectionnee.setNom("Nouveau nom");
    selectionnee.setAge(30);
    
    // Le TableView se met à jour AUTOMATIQUEMENT !
    // Pas besoin d'appeler refresh()
}
```

