package application;

import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MainController {
	
	@FXML
	private TableView<Personne> tableViewPersonnes;
	
	@FXML
	private TableColumn<Personne, String> colNom;
	
	@FXML
	private TableColumn<Personne, String> colPrenom;
	
	@FXML
	private TableColumn<Personne, Integer> colAge;
	
	@FXML
	private TableColumn<Personne, String> colEmail;
	
	@FXML
	private TextField txtNom;
	
	@FXML
	private TextField txtPrenom;
	
	@FXML
	private TextField txtAge;
	
	@FXML
	private TextField txtEmail;
	
	@FXML
	private Button btnModifier;
	
	@FXML
	private Button btnAugmenterAge;
	
	@FXML
	private Label lblInfo;
	
	private ObservableList<Personne> personnes;
	
	@FXML
	private void initialize() {
		// Créer les données avec propriétés observables
		personnes = FXCollections.observableArrayList(
			new Personne("Dupont", "Jean", 25, "jean@exemple.com"),
			new Personne("Martin", "Marie", 30, "marie@exemple.com"),
			new Personne("Bernard", "Pierre", 28, "pierre@exemple.com"),
			new Personne("Dubois", "Sophie", 32, "sophie@exemple.com"),
			new Personne("Lefebvre", "Thomas", 26, "thomas@exemple.com")
		);
		
		// PropertyValueFactory utilise automatiquement les propriétés observables
		colNom.setCellValueFactory(new PropertyValueFactory<>("nom"));
		colPrenom.setCellValueFactory(new PropertyValueFactory<>("prenom"));
		colAge.setCellValueFactory(new PropertyValueFactory<>("age"));
		colEmail.setCellValueFactory(new PropertyValueFactory<>("email"));
		
		// Définir les titres des colonnes
		colNom.setText("Nom");
		colPrenom.setText("Prénom");
		colAge.setText("Âge");
		colEmail.setText("Email");
		
		// Lier la liste au TableView
		tableViewPersonnes.setItems(personnes);
		
		// Écouter les changements de sélection
		tableViewPersonnes.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
			if (newVal != null) {
				// Remplir les champs avec les données de la personne sélectionnée
				txtNom.setText(newVal.getNom());
				txtPrenom.setText(newVal.getPrenom());
				txtAge.setText(String.valueOf(newVal.getAge()));
				txtEmail.setText(newVal.getEmail());
				
				lblInfo.setText("Sélectionné : " + newVal.getPrenom() + " " + newVal.getNom() + 
				              " (" + newVal.getAge() + " ans)");
			} else {
				txtNom.clear();
				txtPrenom.clear();
				txtAge.clear();
				txtEmail.clear();
				lblInfo.setText("Aucune sélection");
			}
		});
		
		// Initialiser le label
		lblInfo.setText("Nombre de personnes : " + personnes.size() + 
		              " - Modifiez une personne pour voir la mise à jour automatique !");
	}
	
	@FXML
	private void modifierPersonne() {
		Personne selectionnee = tableViewPersonnes.getSelectionModel().getSelectedItem();
		
		if (selectionnee == null) {
			lblInfo.setText("Veuillez sélectionner une personne à modifier");
			return;
		}
		
		try {
			// Modifier les propriétés observables
			selectionnee.setNom(txtNom.getText().trim());
			selectionnee.setPrenom(txtPrenom.getText().trim());
			selectionnee.setEmail(txtEmail.getText().trim());
			
			int age = Integer.parseInt(txtAge.getText().trim());
			selectionnee.setAge(age);
			
			// Le TableView se met à jour AUTOMATIQUEMENT grâce aux propriétés observables !
			// Pas besoin d'appeler refresh()
			
			lblInfo.setText("Personne modifiée - Le TableView se met à jour automatiquement !");
		} catch (NumberFormatException e) {
			lblInfo.setText("Erreur : Âge invalide");
		}
	}
	
	@FXML
	private void augmenterAge() {
		Personne selectionnee = tableViewPersonnes.getSelectionModel().getSelectedItem();
		
		if (selectionnee != null) {
			// Modifier l'âge directement
			selectionnee.setAge(selectionnee.getAge() + 1);
			
			// Le TableView se met à jour automatiquement !
			// Le champ txtAge aussi grâce au listener de sélection
			
			lblInfo.setText("Âge augmenté - Mise à jour automatique !");
		} else {
			lblInfo.setText("Veuillez sélectionner une personne");
		}
	}
}

