# Chapitre 6.3.4 - TableView : Édition de cellule (optionnel)

Ce projet Eclipse illustre l'édition directe des cellules dans un TableView JavaFX, comme présenté dans la section 6.3.4 du cours.

## Description

Ce projet démontre comment activer et utiliser l'édition de cellule dans un TableView :

- **Édition activée** : `setEditable(true)` sur le TableView
- **CellFactory éditable** : TextFieldTableCell pour chaque colonne
- **OnEditCommit** : Sauvegarde les modifications quand l'édition est terminée
- **StringConverter** : Utilisation d'IntegerStringConverter pour la colonne âge
- **Mise à jour automatique** : Grâce aux propriétés observables

## Structure du projet

```
Chapitre6_3_4_EditionCellule/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée
│   │   ├── MainController.java          # Contrôleur avec édition de cellule
│   │   ├── Personne.java                # Classe modèle avec propriétés observables
│   │   ├── main.fxml                   # Interface utilisateur
│   │   └── style.css                   # Styles CSS
│   └── module-info.java                # Configuration du module
├── .project                            # Configuration Eclipse
└── .classpath                          # Configuration du classpath
```

## Fonctionnalités

### 1. Édition activée
- `tableView.setEditable(true)` : Active l'édition sur le TableView
- Toutes les colonnes sont éditables

### 2. CellFactory éditables
- **TextFieldTableCell** : Pour les colonnes String (nom, prénom, email)
- **TextFieldTableCell avec IntegerStringConverter** : Pour la colonne Integer (âge)

### 3. OnEditCommit
- Sauvegarde automatique des modifications
- Affichage d'un message de confirmation
- Mise à jour automatique grâce aux propriétés observables

### 4. Comment éditer
- **Double-cliquer** sur une cellule (ou appuyer sur F2)
- **Modifier** la valeur dans le champ de texte
- **Entrée** : Valider la modification
- **Échap** : Annuler la modification

## Comment utiliser

1. **Ouvrir le projet dans Eclipse**
2. **Exécuter** : Run As → Java Application
3. **Tester l'édition** :
   - Double-cliquer sur une cellule pour l'éditer
   - Modifier la valeur
   - Appuyer sur Entrée pour valider
   - Observer la mise à jour automatique

## Points clés

- **setEditable(true)** : Active l'édition sur le TableView
- **TextFieldTableCell.forTableColumn()** : Crée une cellule éditable pour String
- **TextFieldTableCell.forTableColumn(converter)** : Crée une cellule éditable avec convertisseur
- **setOnEditCommit()** : Définit l'action à exécuter quand l'édition est terminée
- **event.getRowValue()** : Récupère l'objet de la ligne modifiée
- **event.getNewValue()** : Récupère la nouvelle valeur

## Types de cellules éditables

- **TextFieldTableCell** : Pour les String (texte)
- **CheckBoxTableCell** : Pour les Boolean (cases à cocher)
- **ChoiceBoxTableCell** : Pour les choix dans une liste
- **ComboBoxTableCell** : Pour les choix dans une liste déroulante

## Code clé

### Activer l'édition
```java
// Activer l'édition sur le TableView
tableViewPersonnes.setEditable(true);

// Activer l'édition pour une colonne String
colNom.setCellFactory(TextFieldTableCell.forTableColumn());
colNom.setOnEditCommit(event -> {
    Personne personne = event.getRowValue();
    personne.setNom(event.getNewValue());
});

// Activer l'édition pour une colonne Integer
colAge.setCellFactory(TextFieldTableCell.forTableColumn(new IntegerStringConverter()));
colAge.setOnEditCommit(event -> {
    Personne personne = event.getRowValue();
    personne.setAge(event.getNewValue());
});
```

## Avantages

- ✅ Modification rapide directement dans le tableau
- ✅ Interface simple et intuitive
- ✅ Pas besoin de formulaire séparé
- ✅ Mise à jour automatique grâce aux propriétés observables

## Quand utiliser ?

- ✅ Modification rapide de données simples
- ✅ Interface simple sans formulaire
- ✅ Données simples (texte, nombres)
- ✅ Expérience utilisateur améliorée

## Quand ne pas utiliser ?

- ❌ Modifications complexes nécessitant validation
- ❌ Données avec relations complexes
- ❌ Besoin de validation avancée
- ❌ Modification de plusieurs champs en même temps

