package application;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MainController {
	
	@FXML
	private TableView<Personne> tableViewPersonnes;
	
	@FXML
	private TableColumn<Personne, String> colNom;
	
	@FXML
	private TableColumn<Personne, String> colPrenom;
	
	@FXML
	private TableColumn<Personne, Integer> colAge;
	
	@FXML
	private TableColumn<Personne, String> colEmail;
	
	@FXML
	private Label lblInfo;
	
	private ObservableList<Personne> personnes;
	
	@FXML
	private void initialize() {
		// Créer les données avec propriétés observables
		personnes = FXCollections.observableArrayList(
			new Personne("Dupont", "Jean", 25, "jean@exemple.com"),
			new Personne("Martin", "Marie", 30, "marie@exemple.com"),
			new Personne("Bernard", "Pierre", 28, "pierre@exemple.com"),
			new Personne("Dubois", "Sophie", 32, "sophie@exemple.com"),
			new Personne("Lefebvre", "Thomas", 26, "thomas@exemple.com")
		);
		
		// PropertyValueFactory utilise automatiquement les propriétés observables
		colNom.setCellValueFactory(new PropertyValueFactory<>("nom"));
		colPrenom.setCellValueFactory(new PropertyValueFactory<>("prenom"));
		colAge.setCellValueFactory(new PropertyValueFactory<>("age"));
		colEmail.setCellValueFactory(new PropertyValueFactory<>("email"));
		
		// Définir les titres des colonnes
		colNom.setText("Nom");
		colPrenom.setText("Prénom");
		colAge.setText("Âge");
		colEmail.setText("Email");
		
		// ============================================
		// ACTIVER L'ÉDITION SUR LE TABLEVIEW
		// ============================================
		tableViewPersonnes.setEditable(true);
		
		// ============================================
		// CONFIGURER L'ÉDITION POUR CHAQUE COLONNE
		// ============================================
		
		// Colonne Nom : TextFieldTableCell pour String
		colNom.setCellFactory(TextFieldTableCell.forTableColumn());
		colNom.setOnEditCommit(event -> {
			Personne personne = event.getRowValue();
			personne.setNom(event.getNewValue());
			lblInfo.setText("Nom modifié : " + event.getNewValue());
		});
		
		// Colonne Prénom : TextFieldTableCell pour String
		colPrenom.setCellFactory(TextFieldTableCell.forTableColumn());
		colPrenom.setOnEditCommit(event -> {
			Personne personne = event.getRowValue();
			personne.setPrenom(event.getNewValue());
			lblInfo.setText("Prénom modifié : " + event.getNewValue());
		});
		
		// Colonne Email : TextFieldTableCell pour String
		colEmail.setCellFactory(TextFieldTableCell.forTableColumn());
		colEmail.setOnEditCommit(event -> {
			Personne personne = event.getRowValue();
			personne.setEmail(event.getNewValue());
			lblInfo.setText("Email modifié : " + event.getNewValue());
		});
		
		// Colonne Âge : TextFieldTableCell avec IntegerStringConverter
		colAge.setCellFactory(TextFieldTableCell.forTableColumn(new IntegerStringConverter()));
		colAge.setOnEditCommit(event -> {
			Personne personne = event.getRowValue();
			personne.setAge(event.getNewValue());
			lblInfo.setText("Âge modifié : " + event.getNewValue() + " ans");
		});
		
		// Lier la liste au TableView
		tableViewPersonnes.setItems(personnes);
		
		// Écouter les changements de sélection
		tableViewPersonnes.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
			if (newVal != null) {
				lblInfo.setText("Sélectionné : " + newVal.getPrenom() + " " + newVal.getNom() + 
				              " (" + newVal.getAge() + " ans) - Double-cliquez sur une cellule pour éditer");
			} else {
				lblInfo.setText("Aucune sélection - Double-cliquez sur une cellule pour éditer");
			}
		});
		
		// Initialiser le label
		lblInfo.setText("Double-cliquez sur une cellule pour l'éditer directement !");
	}
}

