package application;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Personne {
    private StringProperty nom = new SimpleStringProperty();
    private StringProperty prenom = new SimpleStringProperty();
    private IntegerProperty age = new SimpleIntegerProperty();
    private StringProperty email = new SimpleStringProperty();
    
    public Personne(String nom, String prenom, int age, String email) {
        this.nom.set(nom);
        this.prenom.set(prenom);
        this.age.set(age);
        this.email.set(email);
    }
    
    // Getters pour les propriétés (nécessaires pour PropertyValueFactory)
    public StringProperty nomProperty() { 
        return nom; 
    }
    
    public StringProperty prenomProperty() { 
        return prenom; 
    }
    
    public IntegerProperty ageProperty() { 
        return age; 
    }
    
    public StringProperty emailProperty() { 
        return email; 
    }
    
    // Getters classiques
    public String getNom() { 
        return nom.get(); 
    }
    
    public String getPrenom() { 
        return prenom.get(); 
    }
    
    public int getAge() { 
        return age.get(); 
    }
    
    public String getEmail() { 
        return email.get(); 
    }
    
    // Setters
    public void setNom(String nom) { 
        this.nom.set(nom); 
    }
    
    public void setPrenom(String prenom) { 
        this.prenom.set(prenom); 
    }
    
    public void setAge(int age) { 
        this.age.set(age); 
    }
    
    public void setEmail(String email) { 
        this.email.set(email); 
    }
}

