# Projet d'exemple - Stage secondaire (fenêtre enfant) (7.2.2)

Ce projet illustre la section 7.2.2 "Stage secondaire (fenêtre enfant)" du chapitre 7.

## 📁 Structure du projet

```
src/application/
├── Main.java                          # Classe principale
├── MainController.java                # Contrôleur de la fenêtre principale
├── FenetreSecondaireController.java   # Contrôleur de la fenêtre secondaire simple
├── FenetreParametresController.java   # Contrôleur de la fenêtre de paramètres
├── main.fxml                          # Interface de la fenêtre principale
├── fenetreSecondaire.fxml             # Interface de la fenêtre secondaire simple
├── fenetreParametres.fxml             # Interface de la fenêtre de paramètres
└── style.css                          # Fichier de style CSS
```

## 🎯 Fonctionnalités

Ce projet démontre l'utilisation des Stages secondaires (fenêtres enfants) :

- **Fenêtre principale** : Interface simple avec des boutons pour ouvrir les fenêtres secondaires
- **Fenêtre secondaire simple** : Exemple basique d'une fenêtre secondaire non-modale
- **Fenêtre de paramètres** : Exemple plus complet avec des champs de saisie

## 🚀 Comment lancer le projet

1. Ouvrez le projet dans Eclipse
2. Clic droit sur `Main.java`
3. Run As → Java Application
4. L'application se lance avec la fenêtre principale

## 📝 Comment tester

1. **Cliquez sur "Ouvrir fenêtre secondaire"** : Une nouvelle fenêtre s'ouvre
2. **Testez la non-modalité** : Vous pouvez interagir avec la fenêtre principale même quand la secondaire est ouverte
3. **Cliquez sur "Ouvrir paramètres"** : Une fenêtre de paramètres s'ouvre avec des champs
4. **Testez les deux fenêtres** : Ouvrez les deux fenêtres secondaires en même temps
5. **Fermez les fenêtres** : Cliquez sur "Fermer" ou "Annuler" pour fermer les fenêtres secondaires

## 💡 Points importants

- **Non-modale par défaut** : Les fenêtres secondaires sont non-modales (vous pouvez utiliser les deux fenêtres)
- **initOwner()** : La fenêtre principale est définie comme parent (la secondaire se ferme si la principale se ferme)
- **Positionnement** : Les fenêtres secondaires sont centrées par rapport à la principale
- **FXML + Scene Builder** : Toutes les interfaces sont créées dans Scene Builder
- **Contrôleurs séparés** : Chaque fenêtre a son propre contrôleur

## 🔧 Différence avec les dialogues

- **Dialogues (section 7.2.1)** : Modaux, bloquent l'interaction avec le reste de l'application
- **Stages secondaires (section 7.2.2)** : Non-modaux par défaut, permettent d'utiliser plusieurs fenêtres en même temps

## ✏️ Modifier le projet

Vous pouvez modifier ce projet pour apprendre :

- **Ajouter une nouvelle fenêtre secondaire** : Créez un nouveau FXML et contrôleur
- **Rendre une fenêtre modale** : Utilisez `initModality(Modality.APPLICATION_MODAL)`
- **Modifier le positionnement** : Changez les valeurs de `setX()` et `setY()`
- **Ajouter des fonctionnalités** : Ajoutez plus de champs dans la fenêtre de paramètres

## ⚠️ Important

- Les fenêtres secondaires sont créées avec `new Stage()`
- Utilisez `initOwner()` pour définir la fenêtre parente (recommandé)
- Les fenêtres secondaires sont non-modales par défaut
- Créez toutes les interfaces dans Scene Builder (FXML)
- Le CSS est déclaré dans les FXML avec `stylesheets="@style.css"`

