package application;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main extends Application {
    
    @Override
    public void start(Stage primaryStage) {
        try {
            // Charger l'interface principale
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(getClass().getResource("main.fxml"));
            Scene scene = new Scene(loader.load());
            
            // Récupérer le contrôleur et lui donner la référence au Stage
            MainController controller = loader.getController();
            controller.setStagePrincipal(primaryStage);
            
            // Afficher la fenêtre
            primaryStage.setScene(scene);
            primaryStage.setTitle("Fenêtre principale - Exemples de Stages secondaires");
            primaryStage.setWidth(600);
            primaryStage.setHeight(400);
            primaryStage.show();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public static void main(String[] args) {
        launch(args);
    }
}

