package application;

import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class MainController {
    
    private Stage stagePrincipal; // La fenêtre principale
    
    // Cette méthode est appelée quand on clique sur "Ouvrir fenêtre secondaire"
    @FXML
    private void ouvrirFenetreSecondaire() {
        try {
            // Charger le FXML de la fenêtre secondaire
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(getClass().getResource("fenetreSecondaire.fxml"));
            Scene scene = new Scene(loader.load());
            
            // Créer un nouveau Stage (fenêtre)
            Stage stageSecondaire = new Stage();
            stageSecondaire.setScene(scene);
            stageSecondaire.setTitle("Fenêtre secondaire");
            stageSecondaire.setWidth(400);
            stageSecondaire.setHeight(300);
            
            // Définir la fenêtre principale comme parent (optionnel mais recommandé)
            stageSecondaire.initOwner(stagePrincipal);
            
            // Centrer la fenêtre secondaire par rapport à la principale
            stageSecondaire.setX(stagePrincipal.getX() + (stagePrincipal.getWidth() - stageSecondaire.getWidth()) / 2);
            stageSecondaire.setY(stagePrincipal.getY() + (stagePrincipal.getHeight() - stageSecondaire.getHeight()) / 2);
            
            // Donner la référence au contrôleur
            FenetreSecondaireController controller = loader.getController();
            controller.setStage(stageSecondaire);
            
            stageSecondaire.initModality(Modality.NONE);
            // Afficher la fenêtre
            stageSecondaire.show();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    // Cette méthode est appelée quand on clique sur "Ouvrir paramètres"
    @FXML
    private void ouvrirParametres() {
        try {
            // Charger le FXML de la fenêtre de paramètres
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(getClass().getResource("fenetreParametres.fxml"));
            Scene scene = new Scene(loader.load());
            
            // Créer un nouveau Stage (fenêtre)
            Stage stageParametres = new Stage();
            stageParametres.setScene(scene);
            stageParametres.setTitle("Paramètres");
            stageParametres.setWidth(400);
            stageParametres.setHeight(300);
            
            // Définir la fenêtre principale comme parent
            stageParametres.initOwner(stagePrincipal);
            //stageParametres.initModality(Modality.APPLICATION_MODAL);
            
            // Centrer la fenêtre
            stageParametres.setX(stagePrincipal.getX() + (stagePrincipal.getWidth() - stageParametres.getWidth()) / 2);
            stageParametres.setY(stagePrincipal.getY() + (stagePrincipal.getHeight() - stageParametres.getHeight()) / 2);
            
            // Donner la référence au contrôleur
            FenetreParametresController controller = loader.getController();
            controller.setStage(stageParametres);
            
            // Afficher la fenêtre
            stageParametres.show();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    // Cette méthode permet de donner la référence au Stage principal
    public void setStagePrincipal(Stage stage) {
        this.stagePrincipal = stage;
    }
}

