# Chapitre 7.2.3 - Exemple Complet : Fenêtre Modale de Saisie

Ce projet Eclipse illustre l'exemple complet de la section 7.2.3 du cours JavaFX sur les fenêtres modales.

## Description

Ce projet démontre comment créer une fenêtre modale qui demande à l'utilisateur de saisir son nom, prénom et âge. Après avoir cliqué sur OK, les informations saisies sont affichées dans la fenêtre parente. Si l'utilisateur clique sur Annuler, la fenêtre modale se ferme simplement sans rien afficher.

## Structure du projet

```
Chapitre7_2_3_ExempleComplet/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée de l'application
│   │   ├── MainController.java          # Contrôleur de la fenêtre principale
│   │   ├── FenetreSaisieController.java # Contrôleur de la fenêtre modale
│   │   ├── main.fxml                    # Interface de la fenêtre principale
│   │   ├── FenetreSaisie.fxml           # Interface de la fenêtre modale
│   │   └── style.css                    # Fichier de styles CSS
│   └── module-info.java                 # Configuration du module Java
├── .project                             # Configuration Eclipse
└── .classpath                           # Configuration du classpath
```

## Fonctionnalités

1. **Fenêtre principale** :
   - Bouton pour ouvrir la fenêtre modale
   - Label pour afficher les informations saisies
   - Label pour afficher les messages (succès/annulation)

2. **Fenêtre modale** :
   - Champs de saisie : Prénom, Nom, Âge
   - Boutons OK et Annuler
   - Validation : tous les champs doivent être remplis
   - Modalité : APPLICATION_MODAL (bloque toute l'application)

3. **Communication entre fenêtres** :
   - Le contrôleur de la fenêtre modale stocke les données
   - Le contrôleur principal récupère les données après fermeture
   - Affichage conditionnel selon le choix de l'utilisateur

## Comment utiliser

1. **Ouvrir le projet dans Eclipse** :
   - File → Open Projects from File System
   - Sélectionner le dossier `Chapitre7_2_3_ExempleComplet`

2. **Configurer JavaFX** :
   - Assurez-vous que JavaFX SDK est configuré dans Eclipse
   - Le projet utilise JavaFX 25 (modifiable dans `.classpath`)

3. **Exécuter l'application** :
   - Clic droit sur `Main.java`
   - Run As → Java Application

## Points clés à retenir

- **Modalité** : `Modality.APPLICATION_MODAL` bloque toute l'application
- **showAndWait()** : Attend la fermeture de la fenêtre modale
- **Classes CSS** : Utilisation de `getStyleClass()` au lieu de `setStyle()`
- **Communication** : Les données sont récupérées après `showAndWait()`
- **Validation** : Vérification que tous les champs sont remplis avant de fermer

## Styles CSS

Le fichier `style.css` contient :
- `.message-success` : Texte vert pour les messages de succès
- `.message-warning` : Texte orange pour les messages d'avertissement
- `.dialog-content` : Padding pour le contenu des dialogues

## Notes

- Tous les styles CSS sont définis dans le fichier externe `style.css`
- Aucun style inline dans le code Java (utilisation de classes CSS)
- Les messages sont affichés dans la fenêtre principale via des Labels

