package application;

import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class FenetreSaisieController {
	
	@FXML
	private TextField txtPrenom;
	
	@FXML
	private TextField txtNom;
	
	@FXML
	private TextField txtAge;
	
	private Stage stage;
	private boolean valide = false;
	private String prenom;
	private String nom;
	private String age;
	
	// Méthodes pour récupérer les données saisies
	public String getPrenom() {
		return prenom;
	}
	
	public String getNom() {
		return nom;
	}
	
	public String getAge() {
		return age;
	}
	
	// Méthode pour vérifier si l'utilisateur a validé
	public boolean estValide() {
		return valide;
	}
	
	@FXML
	private void valider() {
		// Récupérer les valeurs saisies
		prenom = txtPrenom.getText().trim();
		nom = txtNom.getText().trim();
		age = txtAge.getText().trim();
		
		// Vérifier que les champs ne sont pas vides
		if (prenom.isEmpty() || nom.isEmpty() || age.isEmpty()) {
			// Ne pas fermer la fenêtre, l'utilisateur doit remplir tous les champs
			return;
		}
		
		valide = true;
		if (stage != null) {
			stage.close();
		}
	}
	
	@FXML
	private void annuler() {
		valide = false;
		if (stage != null) {
			stage.close();
		}
	}
	
	public void setStage(Stage stage) {
		this.stage = stage;
	}
}

