package application;

import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class MainController {
	
	@FXML
	private Label lblAffichage; // Label dans la fenêtre principale pour afficher les infos
	
	@FXML
	private Label lblMessage; // Label pour afficher les messages (erreurs, annulation, etc.)
	
	private Stage stagePrincipal;
	
	@FXML
	private void ouvrirFenetreSaisie() {
		try {
			// Charger la fenêtre de saisie
			FXMLLoader loader = new FXMLLoader(getClass().getResource("FenetreSaisie.fxml"));
			Scene scene = new Scene(loader.load());
			
			// Créer le Stage modale
			Stage stageSaisie = new Stage();
			stageSaisie.setScene(scene);
			stageSaisie.setTitle("Saisie d'informations");
			stageSaisie.setResizable(false);
			
			// Définir comme modale pour toute l'application
			stageSaisie.initOwner(stagePrincipal);
			stageSaisie.initModality(Modality.APPLICATION_MODAL);
			
			// Configurer le contrôleur
			FenetreSaisieController controller = loader.getController();
			controller.setStage(stageSaisie);
			
			// Afficher et attendre la réponse
			stageSaisie.showAndWait();
			
			// Vérifier le résultat
			if (controller.estValide()) {
				// L'utilisateur a cliqué sur OK et les champs sont remplis
				String prenom = controller.getPrenom();
				String nom = controller.getNom();
				String age = controller.getAge();
				
				// Afficher les informations dans la fenêtre parente
				String message = String.format("Prénom : %s\nNom : %s\nÂge : %s ans", 
												prenom, nom, age);
				lblAffichage.setText(message);
				
				// Afficher un message de confirmation
				if (lblMessage != null) {
					lblMessage.setText("Informations saisies avec succès !");
					lblMessage.getStyleClass().setAll("message-success");
				}
			} else {
				// L'utilisateur a cliqué sur Annuler ou fermé la fenêtre
				if (lblMessage != null) {
					lblMessage.setText("Saisie annulée");
					lblMessage.getStyleClass().setAll("message-warning");
				}
				// Effacer l'affichage précédent
				lblAffichage.setText("");
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void setStagePrincipal(Stage stage) {
		this.stagePrincipal = stage;
	}
}

