# Chapitre 7.2.3 - Exemples de Modalité JavaFX

Ce projet Eclipse démontre les trois types de modalité disponibles en JavaFX :

1. **WINDOW_MODAL** : La fenêtre bloque uniquement l'interaction avec sa fenêtre parente
2. **APPLICATION_MODAL** : La fenêtre bloque l'interaction avec toute l'application
3. **NONE** : La fenêtre est non-modale (vous pouvez utiliser toutes les fenêtres en même temps)

## Structure du projet

- `Main.java` : Point d'entrée de l'application
- `MainController.java` : Contrôleur de la fenêtre principale avec trois méthodes pour ouvrir les fenêtres modales
- `FenetreModaleController.java` : Contrôleur de la fenêtre modale (réutilisé pour les trois types)
- `main.fxml` : Interface de la fenêtre principale avec trois boutons
- `fenetreModale.fxml` : Interface de la fenêtre modale
- `style.css` : Fichier de styles CSS

## Utilisation

1. Ouvrez le projet dans Eclipse
2. Exécutez la classe `Main`
3. Cliquez sur les trois boutons pour tester les différents types de modalité
4. Observez la différence de comportement entre chaque type

## Points importants

- **WINDOW_MODAL** : Utilise `showAndWait()` - bloque uniquement la fenêtre parente
- **APPLICATION_MODAL** : Utilise `showAndWait()` - bloque toute l'application
- **NONE** : Utilise `show()` - n'attend pas, le code continue immédiatement

## Bonnes pratiques respectées

- ✅ Les tailles des fenêtres sont définies dans les FXML avec `prefWidth` et `prefHeight`
- ✅ Pas d'utilisation de `setWidth()` et `setHeight()` dans le code Java
- ✅ Utilisation de classes CSS externes (pas de `setStyle()` dans le code Java)
- ✅ Utilisation de `FXMLLoader(getClass().getResource(...))` pour charger les FXML




