package application;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.stage.Stage;

public class FenetreModaleController {
	
	@FXML
	private Label lblTypeModalite;
	
	@FXML
	private Label lblDescription;
	
	private Stage stage;
	private String typeModalite;
	
	@FXML
	private void initialize() {
		// Cette méthode est appelée automatiquement après le chargement du FXML
		// Les labels seront mis à jour quand setTypeModalite() sera appelé
	}
	
	private void updateLabels() {
		if (typeModalite != null && lblTypeModalite != null && lblDescription != null) {
			lblTypeModalite.setText("Type de modalité : " + typeModalite);
			
			switch (typeModalite) {
				case "WINDOW_MODAL":
					lblDescription.setText("Cette fenêtre bloque uniquement l'interaction avec la fenêtre parente.\nVous pouvez toujours utiliser d'autres fenêtres de l'application.");
					break;
				case "APPLICATION_MODAL":
					lblDescription.setText("Cette fenêtre bloque l'interaction avec toute l'application.\nVous ne pouvez pas utiliser d'autres fenêtres tant que celle-ci est ouverte.");
					break;
				case "NONE":
					lblDescription.setText("Cette fenêtre est non-modale.\nVous pouvez utiliser toutes les fenêtres en même temps.");
					break;
				default:
					lblDescription.setText("");
			}
		}
	}
	
	@FXML
	private void fermer() {
		if (stage != null) {
			stage.close();
		}
	}
	
	public void setStage(Stage stage) {
		this.stage = stage;
	}
	
	public void setTypeModalite(String typeModalite) {
		this.typeModalite = typeModalite;
		updateLabels();
	}
}

