package application;

import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class MainController {
	
	private Stage stagePrincipal;
	
	@FXML
	private void ouvrirFenetreWindowModal() {
		try {
			// Charger le FXML de la fenêtre modale
			FXMLLoader loader = new FXMLLoader(getClass().getResource("fenetreModale.fxml"));
			Scene scene = new Scene(loader.load());
			
			// Créer un nouveau Stage
			Stage stageModale = new Stage();
			stageModale.setScene(scene);
			stageModale.setTitle("Fenêtre modale (WINDOW_MODAL)");
			
			// Définir la fenêtre principale comme parent
			stageModale.initOwner(stagePrincipal);
			
			// Rendre la fenêtre modale par rapport à la fenêtre parente
			stageModale.initModality(Modality.WINDOW_MODAL);
			
			// Donner la référence au contrôleur
			FenetreModaleController controller = loader.getController();
			controller.setStage(stageModale);
			controller.setTypeModalite("WINDOW_MODAL");
			
			// Afficher la fenêtre (bloquera l'interaction avec la fenêtre principale)
			stageModale.showAndWait();
			
			// Ce code s'exécutera seulement après la fermeture de la fenêtre modale
			// Vous pouvez ici récupérer les données du contrôleur si nécessaire
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@FXML
	private void ouvrirFenetreApplicationModal() {
		try {
			FXMLLoader loader = new FXMLLoader(getClass().getResource("fenetreModale.fxml"));
			Scene scene = new Scene(loader.load());
			
			Stage stageModale = new Stage();
			stageModale.setScene(scene);
			stageModale.setTitle("Fenêtre modale (APPLICATION_MODAL)");
			
			// Définir la fenêtre principale comme parent (optionnel mais recommandé)
			stageModale.initOwner(stagePrincipal);
			
			// Rendre la fenêtre modale pour toute l'application
			stageModale.initModality(Modality.APPLICATION_MODAL);
			
			FenetreModaleController controller = loader.getController();
			controller.setStage(stageModale);
			controller.setTypeModalite("APPLICATION_MODAL");
			
			// Afficher et attendre
			stageModale.showAndWait();
			
			// Vous pouvez ici récupérer les données du contrôleur si nécessaire
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@FXML
	private void ouvrirFenetreNone() {
		try {
			FXMLLoader loader = new FXMLLoader(getClass().getResource("fenetreModale.fxml"));
			Scene scene = new Scene(loader.load());
			
			Stage stageSecondaire = new Stage();
			stageSecondaire.setScene(scene);
			stageSecondaire.setTitle("Fenêtre non-modale (NONE)");
			
			stageSecondaire.initOwner(stagePrincipal);
			
			// Expliciter que la fenêtre est non-modale (optionnel, c'est le défaut)
			stageSecondaire.initModality(Modality.NONE);
			
			FenetreModaleController controller = loader.getController();
			controller.setStage(stageSecondaire);
			controller.setTypeModalite("NONE");
			
			// Utiliser show() au lieu de showAndWait() pour ne pas bloquer
			stageSecondaire.show();
			
			// Ce code s'exécutera immédiatement (sans attendre)
			// La fenêtre est maintenant ouverte et l'utilisateur peut l'utiliser
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void setStagePrincipal(Stage stage) {
		this.stagePrincipal = stage;
	}
}




