# Chapitre 7.2.5 - DirectoryChooser (Sélection de dossier)

Ce projet Eclipse illustre l'utilisation de DirectoryChooser pour sélectionner et gérer des dossiers dans JavaFX, comme présenté dans la section 7.2.5 du cours.

## Description

Ce projet démontre comment utiliser `DirectoryChooser` pour :
1. **Sélectionner un dossier** : Choisir un dossier depuis le système de fichiers
2. **Lister le contenu** : Afficher tous les fichiers et dossiers contenus dans le dossier sélectionné
3. **Filtrer les fichiers** : Lister uniquement les images (fichiers avec extensions .png, .jpg, etc.)
4. **Créer des fichiers** : Créer plusieurs fichiers d'exemple dans le dossier sélectionné

## Structure du projet

```
Chapitre7_2_5_DirectoryChooser/
├── src/
│   ├── application/
│   │   ├── Main.java                    # Point d'entrée de l'application
│   │   ├── MainController.java          # Contrôleur de la fenêtre principale
│   │   ├── main.fxml                    # Interface de l'application
│   │   └── style.css                    # Fichier de styles CSS
│   └── module-info.java                 # Configuration du module Java
├── .project                             # Configuration Eclipse
└── .classpath                           # Configuration du classpath
```

## Fonctionnalités

### 1. Sélection de dossier
- **Bouton "Sélectionner un dossier"** : Ouvre un DirectoryChooser pour choisir un dossier
- **Affichage du chemin** : Le chemin complet du dossier sélectionné est affiché en haut
- **Stockage** : Le dossier sélectionné est stocké pour les opérations suivantes

### 2. Liste du contenu
- **Bouton "Lister le contenu"** : Affiche tous les fichiers et dossiers du dossier sélectionné
- **Séparation** : Les dossiers et fichiers sont listés séparément avec des icônes
- **Tailles** : Les tailles des fichiers sont affichées en octets, Ko ou Mo
- **Compteur** : Le nombre total d'éléments est affiché

### 3. Filtrage des images
- **Bouton "Lister les images"** : Filtre et affiche uniquement les fichiers images
- **Extensions supportées** : PNG, JPG, JPEG, GIF, BMP, WEBP
- **Affichage** : Liste les images avec leurs tailles

### 4. Création de fichiers
- **Bouton "Créer des fichiers"** : Crée 3 fichiers d'exemple dans le dossier sélectionné
- **Actualisation** : Le contenu du dossier est automatiquement rafraîchi après création
- **Fichiers créés** :
  - `exemple_texte.txt` : Fichier texte simple
  - `exemple_data.txt` : Fichier avec plusieurs lignes
  - `exemple_info.txt` : Fichier avec informations et date

## Comment utiliser

1. **Ouvrir le projet dans Eclipse** :
   - File → Open Projects from File System
   - Sélectionner le dossier `Chapitre7_2_5_DirectoryChooser`

2. **Configurer JavaFX** :
   - Assurez-vous que JavaFX SDK est configuré dans Eclipse
   - Le projet utilise JavaFX 25 (modifiable dans `.classpath`)

3. **Exécuter l'application** :
   - Clic droit sur `Main.java`
   - Run As → Java Application

4. **Tester les fonctionnalités** :
   - Cliquez sur "Sélectionner un dossier" et choisissez un dossier
   - Cliquez sur "Lister le contenu" pour voir tous les fichiers et dossiers
   - Cliquez sur "Lister les images" pour voir uniquement les images
   - Cliquez sur "Créer des fichiers" pour créer des fichiers d'exemple

## Points clés à retenir

### DirectoryChooser - Sélection de dossier
- **`showDialog(Stage)`** : Affiche le dialogue de sélection de dossier
- **Résultat** : Retourne un `File` représentant le dossier ou `null` si l'utilisateur annule
- **Répertoire initial** : `setInitialDirectory()` pour définir le dossier de départ

### Manipulation de dossiers
- **`listFiles()`** : Retourne un tableau de tous les fichiers et dossiers
- **`isDirectory()`** : Vérifie si c'est un dossier
- **`isFile()`** : Vérifie si c'est un fichier
- **`getName()`** : Retourne le nom du fichier ou dossier
- **`length()`** : Retourne la taille du fichier en octets

### Création de fichiers dans un dossier
```java
File fichier = new File(dossierCourant, "nomFichier.txt");
java.nio.file.Files.write(fichier.toPath(), contenu.getBytes());
```

### Filtrage des fichiers
```java
String[] extensions = {".png", ".jpg", ".jpeg"};
for (File fichier : fichiers) {
    if (fichier.isFile()) {
        String nom = fichier.getName().toLowerCase();
        for (String ext : extensions) {
            if (nom.endsWith(ext)) {
                // Fichier correspondant trouvé
            }
        }
    }
}
```

## Exemples de code

### Sélectionner un dossier
```java
DirectoryChooser directoryChooser = new DirectoryChooser();
directoryChooser.setTitle("Sélectionner un dossier");
directoryChooser.setInitialDirectory(new File(System.getProperty("user.home")));
File dossier = directoryChooser.showDialog(stagePrincipal);
if (dossier != null) {
    System.out.println("Dossier sélectionné : " + dossier.getAbsolutePath());
}
```

### Lister le contenu d'un dossier
```java
File[] fichiers = dossier.listFiles();
if (fichiers != null) {
    for (File fichier : fichiers) {
        if (fichier.isDirectory()) {
            System.out.println("Dossier : " + fichier.getName());
        } else {
            System.out.println("Fichier : " + fichier.getName() + 
                             " (" + fichier.length() + " octets)");
        }
    }
}
```

### Créer un fichier dans un dossier
```java
File nouveauFichier = new File(dossierCourant, "mon_fichier.txt");
java.nio.file.Files.write(nouveauFichier.toPath(), "Contenu".getBytes());
```

## Styles CSS

Le fichier `style.css` contient :
- `.message-success` : Texte vert pour les messages de succès
- `.message-warning` : Texte orange pour les messages d'avertissement
- `.message-error` : Texte rouge pour les messages d'erreur
- Styles pour les boutons avec effet hover
- Styles pour le TextArea avec police monospace

## Notes importantes

- ✅ **Toujours vérifier `null`** : Le DirectoryChooser retourne `null` si l'utilisateur annule
- ✅ **Gestion d'erreurs** : Utilisez `try-catch` pour la lecture/écriture de fichiers
- ✅ **Vérifier `listFiles()`** : Peut retourner `null` si le dossier est vide ou inaccessible
- ✅ **Distinction fichiers/dossiers** : Utilisez `isDirectory()` et `isFile()` pour distinguer
- ✅ **Formatage des tailles** : Les tailles sont formatées en octets, Ko ou Mo pour la lisibilité
- ✅ **Classes CSS** : Utilisation de `getStyleClass().setAll()` au lieu de `setStyle()`

## Différence avec FileChooser

| FileChooser | DirectoryChooser |
|-------------|------------------|
| Sélectionne un fichier spécifique | Sélectionne un dossier entier |
| `showOpenDialog()` / `showSaveDialog()` | `showDialog()` |
| Utile pour ouvrir/enregistrer un fichier | Utile pour travailler avec des dossiers |
| Filtres d'extension disponibles | Pas de filtres (sélection de dossier uniquement) |

## Compatibilité

- JavaFX 17+
- Java 11+
- Compatible avec Windows, macOS et Linux

## Cas d'usage

Le DirectoryChooser est particulièrement utile pour :
- Applications de sauvegarde (choisir un dossier de destination)
- Explorateurs de fichiers
- Applications de gestion de médias (organiser des images, vidéos)
- Outils de développement (sélectionner un répertoire de projet)
- Applications de synchronisation de fichiers

