# Chapitre 7.3.1 - Passage d'objets (Communication inter-fenêtres)

Ce projet Eclipse illustre les différentes méthodes de passage d'objets entre fenêtres dans JavaFX, comme présenté dans la section 7.3.1 du cours.

## Description

Ce projet démontre **4 méthodes différentes** pour faire communiquer des fenêtres entre elles :

1. **Méthode 1 : Passage simple (String)** - Passer une chaîne de caractères d'une fenêtre principale à une fenêtre secondaire
2. **Méthode 2 : Passage d'objet personnalisé** - Passer un objet `Personne` complet à une fenêtre de détails
3. **Méthode 3 : Récupération depuis fenêtre modale** - Récupérer un objet créé dans une fenêtre modale après sa fermeture
4. **Méthode 4 : Modification par référence** - Modifier directement un objet passé par référence

## Structure du projet

```
Chapitre7_3_1_PassageObjets/
├── src/
│   ├── application/
│   │   ├── Main.java                          # Point d'entrée de l'application
│   │   ├── MainController.java                # Contrôleur de la fenêtre principale
│   │   ├── Personne.java                      # Classe modèle pour représenter une personne
│   │   ├── FenetreSecondaireController.java   # Contrôleur pour méthode 1
│   │   ├── FenetreDetailsController.java     # Contrôleur pour méthode 2
│   │   ├── FenetreSaisieController.java       # Contrôleur pour méthode 3
│   │   ├── FenetreModificationController.java # Contrôleur pour méthode 4
│   │   ├── main.fxml                          # Interface de la fenêtre principale
│   │   ├── fenetreSecondaire.fxml            # Interface pour méthode 1
│   │   ├── fenetreDetails.fxml                # Interface pour méthode 2
│   │   ├── fenetreSaisie.fxml                 # Interface pour méthode 3
│   │   ├── fenetreModification.fxml          # Interface pour méthode 4
│   │   └── style.css                          # Fichier de styles CSS
│   └── module-info.java                       # Configuration du module Java
├── .project                                   # Configuration Eclipse
└── .classpath                                 # Configuration du classpath
```

## Fonctionnalités

### Méthode 1 : Passage simple (String)
- **Bouton "Ouvrir fenêtre secondaire"** : Ouvre une fenêtre secondaire et lui passe un message saisi dans un TextField
- **Fonctionnement** : Le message est passé via la méthode `setMessage()` du contrôleur
- **Fenêtre** : Non-modale (vous pouvez utiliser les deux fenêtres en même temps)

### Méthode 2 : Passage d'objet personnalisé
- **Bouton "Voir détails (Méthode 2)"** : Ouvre une fenêtre de détails avec les informations de la personne sélectionnée
- **Fonctionnement** : L'objet `Personne` complet est passé via `setPersonne()`
- **Affichage** : Toutes les propriétés de la personne sont affichées (nom, prénom, âge, email)

### Méthode 3 : Récupération depuis fenêtre modale
- **Bouton "Ajouter (Méthode 3)"** : Ouvre une fenêtre modale pour saisir une nouvelle personne
- **Fonctionnement** : 
  - L'utilisateur saisit les informations
  - Un objet `Personne` est créé dans le contrôleur
  - Après `showAndWait()`, l'objet est récupéré via `getPersonne()`
  - La personne est ajoutée à la liste
- **Fenêtre** : Modale (bloque l'interaction avec la fenêtre principale)

### Méthode 4 : Modification par référence
- **Bouton "Modifier (Méthode 4)"** : Ouvre une fenêtre modale pour modifier la personne sélectionnée
- **Fonctionnement** :
  - L'objet `Personne` est passé par référence (pas une copie)
  - Les modifications sont appliquées directement sur l'objet original
  - Après fermeture, la ListView est rafraîchie pour afficher les changements
- **Important** : Les modifications affectent l'objet original car c'est une référence

## Comment utiliser

1. **Ouvrir le projet dans Eclipse** :
   - File → Open Projects from File System
   - Sélectionner le dossier `Chapitre7_3_1_PassageObjets`

2. **Configurer JavaFX** :
   - Assurez-vous que JavaFX SDK est configuré dans Eclipse
   - Le projet utilise JavaFX 25 (modifiable dans `.classpath`)

3. **Exécuter l'application** :
   - Clic droit sur `Main.java`
   - Run As → Java Application

4. **Tester les fonctionnalités** :
   - **Méthode 1** : Saisissez un message et cliquez sur "Ouvrir fenêtre secondaire"
   - **Méthode 2** : Sélectionnez une personne dans la liste et cliquez sur "Voir détails"
   - **Méthode 3** : Cliquez sur "Ajouter" et remplissez le formulaire
   - **Méthode 4** : Sélectionnez une personne et cliquez sur "Modifier", puis modifiez les informations

## Points clés à retenir

### Passage par référence en Java
- **Important** : En Java, tous les objets sont passés par référence (pas par valeur)
- Quand vous passez un objet à une méthode, vous passez une référence (adresse mémoire), pas une copie
- Si vous modifiez l'objet dans une fenêtre, les modifications sont visibles partout où l'objet est utilisé

### Méthode 1 : Passage simple
```java
// Dans MainController
controller.setMessage(message); // Passer une String

// Dans FenetreSecondaireController
public void setMessage(String message) {
    lblMessage.setText("Message reçu : " + message);
}
```

### Méthode 2 : Passage d'objet
```java
// Dans MainController
controller.setPersonne(personneSelectionnee); // Passer un objet Personne

// Dans FenetreDetailsController
public void setPersonne(Personne personne) {
    this.personne = personne;
    // Afficher les informations
}
```

### Méthode 3 : Récupération depuis modale
```java
// Dans FenetreSaisieController
private Personne personneCreee;

public Personne getPersonne() {
    return personneCreee;
}

// Dans MainController
stageSaisie.showAndWait();
if (controller.estValide()) {
    Personne nouvellePersonne = controller.getPersonne();
    // Utiliser la nouvelle personne
}
```

### Méthode 4 : Modification par référence
```java
// Dans MainController
controller.setPersonne(personneSelectionnee); // Passer la référence

// Dans FenetreModificationController
public void setPersonne(Personne personne) {
    this.personne = personne; // Référence vers l'objet original
}

// Modifier directement l'objet
personne.setNom(txtNom.getText()); // Modifie l'original !
```

## Différences importantes

| Méthode | Type de passage | Modification de l'original | Utilisation |
|---------|----------------|---------------------------|-------------|
| 1 | Simple (String) | N/A | Affichage d'informations |
| 2 | Objet (lecture) | Non | Affichage de détails |
| 3 | Création | N/A | Ajout d'un nouvel élément |
| 4 | Référence (modification) | **Oui** | Modification d'un élément existant |

## Styles CSS

Le fichier `style.css` contient :
- `.message-success` : Texte vert pour les messages de succès
- `.message-warning` : Texte orange pour les messages d'avertissement
- `.message-error` : Texte rouge pour les messages d'erreur
- Styles pour les boutons avec effet hover
- Styles pour les TextField et ListView

## Notes importantes

- ✅ **Passage par référence** : Tous les objets en Java sont passés par référence
- ✅ **Modification directe** : La méthode 4 modifie l'objet original (pas de copie)
- ✅ **Validation** : Toujours vérifier si l'utilisateur a validé avant d'utiliser les données
- ✅ **Getter/Setter** : Exposez des méthodes getter/setter dans vos contrôleurs
- ✅ **showAndWait()** : Utilisez `showAndWait()` pour les fenêtres modales afin de récupérer les données
- ✅ **ListView.refresh()** : Utilisez `refresh()` pour rafraîchir l'affichage après modification

## Cas d'usage

- **Méthode 1** : Passer des messages, des notifications, des informations simples
- **Méthode 2** : Afficher les détails d'un élément sélectionné
- **Méthode 3** : Créer de nouveaux éléments via un formulaire
- **Méthode 4** : Modifier des éléments existants (formulaires d'édition)

## Compatibilité

- JavaFX 17+
- Java 11+
- Compatible avec Windows, macOS et Linux

