package application;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.stage.Stage;

public class FenetreDetailsController {
    
    @FXML
    private Label lblNom;
    
    @FXML
    private Label lblPrenom;
    
    @FXML
    private Label lblAge;
    
    @FXML
    private Label lblEmail;
    
    private Stage stage;
    private Personne personne;
    
    /**
     * Méthode appelée pour recevoir l'objet Personne
     * MÉTHODE 2 : Passage d'objet personnalisé
     */
    public void setPersonne(Personne personne) {
        this.personne = personne;
        
        // Afficher les informations de la personne
        if (personne != null) {
            lblNom.setText("Nom : " + personne.getNom());
            lblPrenom.setText("Prénom : " + personne.getPrenom());
            lblAge.setText("Âge : " + personne.getAge() + " ans");
            lblEmail.setText("Email : " + personne.getEmail());
        }
    }
    
    @FXML
    private void fermer() {
        if (stage != null) {
            stage.close();
        }
    }
    
    public void setStage(Stage stage) {
        this.stage = stage;
    }
}

