package application;

import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class FenetreModificationController {
    
    @FXML
    private TextField txtNom;
    
    @FXML
    private TextField txtPrenom;
    
    @FXML
    private TextField txtAge;
    
    @FXML
    private TextField txtEmail;
    
    private Stage stage;
    private Personne personne; // Référence à l'objet original
    
    /**
     * Reçoit l'objet Personne à modifier
     * MÉTHODE 4 : Modification par référence
     */
    public void setPersonne(Personne personne) {
        this.personne = personne;
        
        // Pré-remplir les champs avec les valeurs actuelles
        if (personne != null) {
            txtNom.setText(personne.getNom());
            txtPrenom.setText(personne.getPrenom());
            txtAge.setText(String.valueOf(personne.getAge()));
            txtEmail.setText(personne.getEmail());
        }
    }
    
    @FXML
    private void enregistrer() {
        if (personne == null) {
            return;
        }
        
        // Modifier directement l'objet (car c'est une référence)
        personne.setNom(txtNom.getText().trim());
        personne.setPrenom(txtPrenom.getText().trim());
        personne.setEmail(txtEmail.getText().trim());
        
        try {
            int age = Integer.parseInt(txtAge.getText().trim());
            personne.setAge(age);
        } catch (NumberFormatException e) {
            System.err.println("Âge invalide");
            return;
        }
        
        // Fermer la fenêtre
        if (stage != null) {
            stage.close();
        }
    }
    
    @FXML
    private void annuler() {
        if (stage != null) {
            stage.close();
        }
    }
    
    public void setStage(Stage stage) {
        this.stage = stage;
    }
}

