package application;

import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class FenetreSaisieController {
    
    @FXML
    private TextField txtNom;
    
    @FXML
    private TextField txtPrenom;
    
    @FXML
    private TextField txtAge;
    
    @FXML
    private TextField txtEmail;
    
    private Stage stage;
    private Personne personneCreee; // Objet à retourner
    private boolean valide = false;
    
    /**
     * Récupère l'objet Personne créé (ou null si annulé)
     * MÉTHODE 3 : Récupération depuis fenêtre modale
     */
    public Personne getPersonne() {
        return personneCreee;
    }
    
    /**
     * Vérifie si l'utilisateur a validé
     */
    public boolean estValide() {
        return valide;
    }
    
    @FXML
    private void valider() {
        String nom = txtNom.getText().trim();
        String prenom = txtPrenom.getText().trim();
        String ageStr = txtAge.getText().trim();
        String email = txtEmail.getText().trim();
        
        // Validation
        if (nom.isEmpty() || prenom.isEmpty() || ageStr.isEmpty()) {
            return; // Ne pas fermer si les champs obligatoires sont vides
        }
        
        try {
            int age = Integer.parseInt(ageStr);
            
            // Créer l'objet Personne
            personneCreee = new Personne(nom, prenom, age, email);
            valide = true;
            
            // Fermer la fenêtre
            if (stage != null) {
                stage.close();
            }
            
        } catch (NumberFormatException e) {
            // L'âge n'est pas un nombre valide
            System.err.println("Âge invalide : " + ageStr);
        }
    }
    
    @FXML
    private void annuler() {
        valide = false;
        personneCreee = null;
        if (stage != null) {
            stage.close();
        }
    }
    
    public void setStage(Stage stage) {
        this.stage = stage;
    }
}

