package application;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main extends Application {
	
	@Override
	public void start(Stage primaryStage) {
		try {
			FXMLLoader loader = new FXMLLoader(getClass().getResource("main.fxml"));
			Scene scene = new Scene(loader.load());
			
			// Donner la référence du Stage au contrôleur
			MainController controller = loader.getController();
			controller.setStagePrincipal(primaryStage);
			
			primaryStage.setScene(scene);
			primaryStage.setTitle("Exemple Passage d'Objets - Communication inter-fenêtres");
			primaryStage.show();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		launch(args);
	}
}

