package application;

import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.stage.Modality;
import javafx.stage.Stage;

import java.util.ArrayList;
import java.util.List;

public class MainController {
    
    @FXML
    private ListView<Personne> listViewPersonnes;
    
    @FXML
    private TextField txtMessage; // Pour la méthode 1 (passage simple)
    
    @FXML
    private Label lblMessage; // Pour afficher les messages
    
    private Stage stagePrincipal;
    private List<Personne> personnes;
    
    @FXML
    private void initialize() {
        // Initialiser la liste de personnes
        personnes = new ArrayList<>();
        personnes.add(new Personne("Dupont", "Jean", 25, "jean@exemple.com"));
        personnes.add(new Personne("Martin", "Marie", 30, "marie@exemple.com"));
        personnes.add(new Personne("Bernard", "Pierre", 28, "pierre@exemple.com"));
        personnes.add(new Personne("Dubois", "Sophie", 32, "sophie@exemple.com"));
        
        // Afficher dans la ListView
        listViewPersonnes.getItems().addAll(personnes);
    }
    
    // ============================================
    // MÉTHODE 1 : Passage simple (String)
    // ============================================
    @FXML
    private void ouvrirFenetreSecondaire() {
        try {
            // Récupérer le message saisi
            String message = txtMessage.getText();
            if (message.trim().isEmpty()) {
                message = "Aucun message saisi";
            }
            
            // Charger la fenêtre secondaire
            FXMLLoader loader = new FXMLLoader(getClass().getResource("fenetreSecondaire.fxml"));
            Scene scene = new Scene(loader.load());
            
            // Créer le Stage
            Stage stageSecondaire = new Stage();
            stageSecondaire.setScene(scene);
            stageSecondaire.setTitle("Fenêtre secondaire - Passage simple");
            stageSecondaire.setWidth(400);
            stageSecondaire.setHeight(300);
            stageSecondaire.initOwner(stagePrincipal);
            
            // Récupérer le contrôleur et lui passer le message
            FenetreSecondaireController controller = loader.getController();
            controller.setMessage(message); // Passer le message
            controller.setStage(stageSecondaire);
            
            stageSecondaire.show();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    // ============================================
    // MÉTHODE 2 : Passage d'objet personnalisé
    // ============================================
    @FXML
    private void ouvrirDetails() {
        // Récupérer la personne sélectionnée
        Personne personneSelectionnee = listViewPersonnes.getSelectionModel().getSelectedItem();
        
        if (personneSelectionnee == null) {
            lblMessage.setText("Veuillez sélectionner une personne");
            lblMessage.getStyleClass().setAll("message-warning");
            return;
        }
        
        try {
            // Charger la fenêtre de détails
            FXMLLoader loader = new FXMLLoader(getClass().getResource("fenetreDetails.fxml"));
            Scene scene = new Scene(loader.load());
            
            Stage stageDetails = new Stage();
            stageDetails.setScene(scene);
            stageDetails.setTitle("Détails de la personne");
            stageDetails.setWidth(400);
            stageDetails.setHeight(350);
            stageDetails.initOwner(stagePrincipal);
            
            // Passer l'objet Personne au contrôleur
            FenetreDetailsController controller = loader.getController();
            controller.setPersonne(personneSelectionnee); // Passer l'objet
            controller.setStage(stageDetails);
            
            stageDetails.show();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    // ============================================
    // MÉTHODE 3 : Récupération depuis fenêtre modale
    // ============================================
    @FXML
    private void ouvrirFenetreSaisie() {
        try {
            FXMLLoader loader = new FXMLLoader(getClass().getResource("fenetreSaisie.fxml"));
            Scene scene = new Scene(loader.load());
            
            Stage stageSaisie = new Stage();
            stageSaisie.setScene(scene);
            stageSaisie.setTitle("Ajouter une personne");
            stageSaisie.setWidth(400);
            stageSaisie.setHeight(350);
            stageSaisie.initOwner(stagePrincipal);
            stageSaisie.initModality(Modality.APPLICATION_MODAL);
            
            FenetreSaisieController controller = loader.getController();
            controller.setStage(stageSaisie);
            
            // Afficher et attendre la fermeture
            stageSaisie.showAndWait();
            
            // Récupérer les données après la fermeture
            if (controller.estValide()) {
                Personne nouvellePersonne = controller.getPersonne();
                if (nouvellePersonne != null) {
                    // Ajouter à la liste
                    personnes.add(nouvellePersonne);
                    listViewPersonnes.getItems().add(nouvellePersonne);
                    
                    lblMessage.setText("Personne ajoutée : " + nouvellePersonne);
                    lblMessage.getStyleClass().setAll("message-success");
                    
                    System.out.println("Personne ajoutée : " + nouvellePersonne);
                }
            } else {
                lblMessage.setText("Saisie annulée");
                lblMessage.getStyleClass().setAll("message-warning");
            }
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    // ============================================
    // MÉTHODE 4 : Modification par référence
    // ============================================
    @FXML
    private void modifierPersonne() {
        Personne personneSelectionnee = listViewPersonnes.getSelectionModel().getSelectedItem();
        
        if (personneSelectionnee == null) {
            lblMessage.setText("Veuillez sélectionner une personne à modifier");
            lblMessage.getStyleClass().setAll("message-warning");
            return;
        }
        
        try {
            FXMLLoader loader = new FXMLLoader(getClass().getResource("fenetreModification.fxml"));
            Scene scene = new Scene(loader.load());
            
            Stage stageModification = new Stage();
            stageModification.setScene(scene);
            stageModification.setTitle("Modifier la personne");
            stageModification.setWidth(400);
            stageModification.setHeight(350);
            stageModification.initOwner(stagePrincipal);
            stageModification.initModality(Modality.APPLICATION_MODAL);
            
            FenetreModificationController controller = loader.getController();
            controller.setStage(stageModification);
            controller.setPersonne(personneSelectionnee); // Passer la référence
            
            stageModification.showAndWait();
            
            // L'objet a été modifié directement (par référence)
            // Rafraîchir l'affichage de la ListView
            listViewPersonnes.refresh();
            
            lblMessage.setText("Personne modifiée : " + personneSelectionnee);
            lblMessage.getStyleClass().setAll("message-success");
            
            System.out.println("Personne modifiée : " + personneSelectionnee);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void setStagePrincipal(Stage stage) {
        this.stagePrincipal = stage;
    }
}

