package application;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DbConnexion {
	
	private static final String DB_URL = "jdbc:mysql://localhost:3306/db_javafx";
	private static final String DB_USER = "root";
	private static final String DB_PASSWORD = "";
	
	private static Connection connection = null;
	
	// Obtient une connexion à la base de données (singleton)
	public static Connection getConnection() throws SQLException {
		if (connection == null || connection.isClosed()) {
			try {
				Class.forName("com.mysql.cj.jdbc.Driver");
				connection = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
			} catch (ClassNotFoundException e) {
				throw new SQLException("Driver MySQL non trouvé", e);
			}
		}
		return connection;
	}
	
	// Ferme la connexion
	public static void closeConnection() throws SQLException {
		if (connection != null && !connection.isClosed()) {
			connection.close();
		}
	}
}

