package application;

import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class PersonneFormController {
	
	@FXML
	private TextField fieldId;
	
	@FXML
	private TextField fieldNom;
	
	@FXML
	private TextField fieldPrenom;
	
	@FXML
	private TextField fieldAge;
	
	private Stage dialogStage;
	private Personne personne;
	private boolean okClicked = false;
	
	@FXML
	private void initialize() {
		fieldId.setEditable(false);
		fieldId.setDisable(true);
	}
	
	public void setDialogStage(Stage dialogStage) {
		this.dialogStage = dialogStage;
	}
	
	public void setPersonne(Personne personne) {
		this.personne = personne;
		
		if (personne != null) {
			// Affiche l'ID seulement si la personne existe déjà (ID > 0)
			if (personne.getId() > 0) {
				fieldId.setText(String.valueOf(personne.getId()));
			} else {
				fieldId.setText("(Auto-généré)");
			}
			fieldNom.setText(personne.getNom());
			fieldPrenom.setText(personne.getPrenom());
			fieldAge.setText(String.valueOf(personne.getAge()));
		}
	}
	
	public boolean isOkClicked() {
		return okClicked;
	}
	
	@FXML
	private void handleOk() {
		if (isInputValid()) {
			if (personne == null) {
				personne = new Personne(); // Crée une nouvelle personne si null (ID sera généré par MySQL)
			}
			
			// Ne pas modifier l'ID - il est géré par l'auto-increment de MySQL
			personne.setNom(fieldNom.getText());
			personne.setPrenom(fieldPrenom.getText());
			
			// Validation et conversion de l'âge
			try {
				int age = Integer.parseInt(fieldAge.getText());
				if (age < 0 || age > 150) {
					throw new NumberFormatException();
				}
				personne.setAge(age);
			} catch (NumberFormatException e) {
				Alert alert = new Alert(Alert.AlertType.ERROR);
				alert.setTitle("Erreur de validation");
				alert.setHeaderText("Âge invalide");
				alert.setContentText("L'âge doit être un nombre entre 0 et 150.");
				alert.showAndWait();
				return; // Ne ferme pas la fenêtre si erreur
			}
			
			okClicked = true;
			dialogStage.close();
		}
	}
	
	@FXML
	private void handleCancel() {
		dialogStage.close();
	}
	
	private boolean isInputValid() {
		String errorMessage = "";
		
		if (fieldNom.getText() == null || fieldNom.getText().trim().isEmpty()) {
			errorMessage += "Le nom est requis !\n";
		}
		
		if (fieldPrenom.getText() == null || fieldPrenom.getText().trim().isEmpty()) {
			errorMessage += "Le prénom est requis !\n";
		}
		
		if (fieldAge.getText() == null || fieldAge.getText().trim().isEmpty()) {
			errorMessage += "L'âge est requis !\n";
		} else {
			try {
				int age = Integer.parseInt(fieldAge.getText());
				if (age < 0 || age > 150) {
					errorMessage += "L'âge doit être entre 0 et 150.\n";
				}
			} catch (NumberFormatException e) {
				errorMessage += "L'âge doit être un nombre valide.\n";
			}
		}
		
		if (errorMessage.length() == 0) {
			return true;
		} else {
			Alert alert = new Alert(Alert.AlertType.ERROR);
			alert.setTitle("Erreur de validation");
			alert.setHeaderText("Veuillez corriger les erreurs");
			alert.setContentText(errorMessage);
			alert.showAndWait();
			return false;
		}
	}
	
	public Personne getPersonne() {
		return personne;
	}
}

