# Projet d'exemple - Changer de Scene (7.1.1)

Ce projet illustre la section 7.1.1 "Changer de Scene" du chapitre 7.

## 📁 Structure du projet

```
src/application/
├── Main.java              # Classe principale qui gère la navigation
├── AccueilController.java # Contrôleur de l'écran d'accueil
├── ProfilController.java  # Contrôleur de l'écran de profil
├── accueil.fxml           # Écran d'accueil (créé avec Scene Builder)
├── profil.fxml            # Écran de profil (créé avec Scene Builder)
└── style.css              # Fichier de style CSS
```

## 🚀 Comment lancer le projet

1. Ouvrez le projet dans Eclipse
2. Clic droit sur `Main.java`
3. Run As → Java Application
4. L'application se lance avec l'écran d'accueil

## 🎯 Fonctionnalités

- **Navigation entre deux écrans** : Accueil ↔ Profil
- **FXML créés avec Scene Builder** : Tous les écrans sont visuels
- **CSS externe** : Les styles sont dans `style.css`
- **Code Java simple** : Juste la logique de navigation

## 📝 Comment ça fonctionne

1. Au démarrage, `Main.java` charge `accueil.fxml`
2. Quand on clique sur "Aller au profil", le contrôleur appelle `main.afficherProfil()`
3. `Main` charge `profil.fxml` et change la Scene
4. Pour revenir, même principe avec le bouton "Retour à l'accueil"

## ✏️ Modifier le projet

Vous pouvez modifier ce projet pour apprendre :

- Modifier les FXML dans Scene Builder
- Ajouter des éléments (Labels, Images, etc.)
- Modifier le CSS dans `style.css`
- Ajouter un troisième écran (Paramètres)

## ⚠️ Important

- Tous les écrans doivent être créés dans Scene Builder
- Le CSS est déclaré dans les FXML avec `stylesheets="@style.css"`
- Ne créez jamais d'interface directement en Java

