package application;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main extends Application {
    
    // On garde les références aux Scenes et contrôleurs
    private Stage stage;
    private Scene sceneAccueil;
    private Scene sceneProfil;
    private AccueilController accueilController;
    private ProfilController profilController;
    
    @Override
    public void start(Stage primaryStage) {
        this.stage = primaryStage;
        
        try {
            // Charger l'écran d'accueil
            chargerAccueil();
            
            // Afficher l'écran d'accueil au démarrage
            stage.setScene(sceneAccueil);
            stage.setTitle("Mon Application");
            stage.setWidth(600);
            stage.setHeight(400);
            stage.show();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    // Méthode pour charger l'écran d'accueil
    private void chargerAccueil() throws Exception {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(getClass().getResource("accueil.fxml"));
        sceneAccueil = new Scene(loader.load());
        
        // Récupérer le contrôleur
        accueilController = loader.getController();
        // Lui donner la référence à Main
        accueilController.setMain(this);
    }
    
    // Méthode pour charger l'écran de profil
    private void chargerProfil() throws Exception {
        // Si on ne l'a pas encore chargé, on le charge
        if (sceneProfil == null) {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(getClass().getResource("profil.fxml"));
            sceneProfil = new Scene(loader.load());
            
            // Récupérer le contrôleur
            profilController = loader.getController();
            // Lui donner la référence à Main
            profilController.setMain(this);
        }
    }
    
    // Méthode appelée par AccueilController pour aller au profil
    public void afficherProfil() {
        try {
            chargerProfil();
            stage.setScene(sceneProfil);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    // Méthode appelée par ProfilController pour retourner à l'accueil
    public void afficherAccueil() {
        stage.setScene(sceneAccueil);
    }
    
    public static void main(String[] args) {
        launch(args);
    }
}
