# Projet d'exemple - Modifier le root FXML (7.1.2)

Ce projet illustre la section 7.1.2 "Modifier le root FXML" du chapitre 7.

## 📁 Structure du projet

```
src/application/
├── Main.java                    # Classe principale
├── EcranPrincipalController.java # Contrôleur de l'écran principal
├── ecranPrincipal.fxml          # Écran principal avec menu latéral
├── contenuAccueil.fxml          # Contenu pour la page d'accueil
├── contenuProfil.fxml           # Contenu pour la page de profil
├── contenuParametres.fxml       # Contenu pour la page de paramètres
└── style.css                    # Fichier de style CSS
```

## 🎯 Fonctionnalités

- **Menu latéral fixe** : Le menu à gauche reste toujours visible
- **Contenu changeant** : Seul le contenu de droite change quand on clique sur les boutons
- **Couleurs distinctes** : Chaque contenu a une couleur différente pour voir le changement
- **FXML créés avec Scene Builder** : Tous les écrans sont visuels
- **CSS externe** : Les styles sont dans `style.css`

## 🚀 Comment lancer le projet

1. Ouvrez le projet dans Eclipse
2. Clic droit sur `Main.java`
3. Run As → Java Application
4. L'application se lance avec l'écran principal

## 📝 Comment ça fonctionne

1. Au démarrage, `Main.java` charge `ecranPrincipal.fxml`
2. L'écran principal a un menu à gauche et une zone vide au centre
3. La méthode `initialize()` du contrôleur charge automatiquement le contenu d'accueil
4. Quand on clique sur un bouton du menu, le contrôleur :
   - Vide la zone de contenu avec `clear()`
   - Charge le nouveau FXML de contenu
   - L'ajoute dans la zone
5. Le menu reste à gauche, seul le contenu change !

## 🎨 Couleurs des contenus

- **Accueil** : Vert clair (#e8f5e9)
- **Profil** : Bleu clair (#e3f2fd)
- **Paramètres** : Orange clair (#fff3e0)

Ces couleurs permettent de voir clairement le changement de contenu.

## ✏️ Modifier le projet

Vous pouvez modifier ce projet pour apprendre :

- Modifier les FXML dans Scene Builder
- Ajouter des éléments dans les contenus
- Modifier le CSS dans `style.css`
- Ajouter un quatrième contenu (ex: "À propos")

## ⚠️ Important

- Tous les écrans doivent être créés dans Scene Builder
- Le CSS est déclaré dans les FXML avec `stylesheets="@style.css"`
- Ne créez jamais d'interface directement en Java
- Utilisez `styleClass` pour appliquer les couleurs d'arrière-plan

