package application;

import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.layout.VBox;
import java.io.IOException;

public class EcranPrincipalController {
    
    // La zone où on va changer le contenu
    @FXML
    private VBox zoneContenu;
    
    // Méthode appelée automatiquement après le chargement du FXML
    @FXML
    private void initialize() {
        // Afficher le contenu d'accueil au démarrage
        afficherAccueil();
    }
    
    // Méthode appelée quand on clique sur "Accueil"
    @FXML
    private void afficherAccueil() {
        chargerContenu("contenuAccueil.fxml");
    }
    
    // Méthode appelée quand on clique sur "Profil"
    @FXML
    private void afficherProfil() {
        chargerContenu("contenuProfil.fxml");
    }
    
    // Méthode appelée quand on clique sur "Paramètres"
    @FXML
    private void afficherParametres() {
        chargerContenu("contenuParametres.fxml");
    }
    
    // Méthode qui charge un FXML et le met dans zoneContenu
    private void chargerContenu(String cheminFXML) {
        try {
            // Charger le FXML
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(getClass().getResource(cheminFXML));
            VBox nouveauContenu = loader.load();
            
            // Vider la zone de contenu actuelle
            zoneContenu.getChildren().clear();
            
            // Ajouter le nouveau contenu
            zoneContenu.getChildren().add(nouveauContenu);
            
        } catch (IOException e) {
            System.err.println("Erreur lors du chargement de " + cheminFXML);
            e.printStackTrace();
        }
    }
}

