# Projet d'exemple - Structure multi-écrans simple (7.1.3)

Ce projet illustre la section 7.1.3 "Structure multi-écrans simple" du chapitre 7.

## 📁 Structure du projet

```
src/application/
├── Main.java                    # Classe principale (très simple)
├── NavigationManager.java      # Gestionnaire de navigation
├── AccueilController.java       # Contrôleur de l'écran d'accueil
├── ProfilController.java        # Contrôleur de l'écran de profil
├── ParametresController.java    # Contrôleur de l'écran de paramètres
├── AProposController.java       # Contrôleur de l'écran "À propos"
├── accueil.fxml                 # Écran d'accueil
├── profil.fxml                  # Écran de profil
├── parametres.fxml             # Écran de paramètres
├── aPropos.fxml                 # Écran "À propos"
└── style.css                    # Fichier de style CSS
```

## 🎯 Fonctionnalités

- **4 écrans** : Accueil, Profil, Paramètres, À propos
- **NavigationManager** : Centralise toute la gestion des écrans
- **Navigation fluide** : Les écrans sont chargés une seule fois et réutilisés
- **Contrôleurs simples** : Chaque contrôleur appelle juste NavigationManager
- **Couleurs distinctes** : Chaque écran a une couleur différente pour voir le changement
- **FXML créés avec Scene Builder** : Tous les écrans sont visuels
- **CSS externe** : Les styles sont dans `style.css`

## 🚀 Comment lancer le projet

1. Ouvrez le projet dans Eclipse
2. Clic droit sur `Main.java`
3. Run As → Java Application
4. L'application se lance avec l'écran d'accueil

## 📝 Comment ça fonctionne

1. **Au démarrage** : `Main.java` crée le `NavigationManager` et affiche l'accueil
2. **NavigationManager** : Charge les écrans à la demande et les stocke dans une Map
3. **Premier chargement** : Quand on navigue vers un écran, il est chargé et stocké
4. **Navigations suivantes** : L'écran est récupéré depuis la Map (plus rapide)
5. **Contrôleurs** : Chaque contrôleur appelle `navigationManager.afficherXXX()` pour naviguer

## 🎨 Couleurs des écrans

- **Accueil** : Vert clair (#e8f5e9)
- **Profil** : Bleu clair (#e3f2fd)
- **Paramètres** : Orange clair (#fff3e0)
- **À propos** : Violet clair (#f3e5f5)

Ces couleurs permettent de voir clairement le changement d'écran.

## ✏️ Modifier le projet

Vous pouvez modifier ce projet pour apprendre :

- **Ajouter un nouvel écran** : 
  1. Créez le FXML dans Scene Builder
  2. Créez le contrôleur
  3. Ajoutez la méthode dans NavigationManager
  4. C'est tout !

- **Modifier les FXML** : Ouvrez-les dans Scene Builder et modifiez-les
- **Modifier le CSS** : Changez les couleurs, les tailles dans `style.css`
- **Ajouter des fonctionnalités** : Ajoutez des champs, des boutons, etc.

## 💡 Avantages de cette structure

- **Code organisé** : Chaque classe a une responsabilité claire
- **Facile à étendre** : Ajouter un nouvel écran est très simple
- **Performance** : Les écrans sont chargés une seule fois
- **Maintenable** : Le code est clair et facile à comprendre

## ⚠️ Important

- Tous les écrans doivent être créés dans Scene Builder
- Le CSS est déclaré dans les FXML avec `stylesheets="@style.css"`
- NavigationManager charge et gère tous les écrans
- Les contrôleurs sont très simples : ils appellent juste NavigationManager
- Ne créez jamais d'interface directement en Java

