package application;

import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Stage;
import java.util.HashMap;
import java.util.Map;

public class NavigationManager {
    
    // Le Stage (la fenêtre) de l'application
    private Stage stage;
    
    // On stocke toutes les Scenes dans une Map (comme un dictionnaire)
    // Clé = nom de l'écran, Valeur = la Scene
    private Map<String, Scene> scenes = new HashMap<>();
    
    // Constructeur : on lui donne le Stage
    public NavigationManager(Stage stage) {
        this.stage = stage;
    }
    
    // Méthode pour charger un écran (si pas déjà chargé)
    private Scene chargerScene(String nomFXML, String nomEcran) {
        // Si on l'a déjà chargé, on le récupère
        if (scenes.containsKey(nomEcran)) {
            return scenes.get(nomEcran);
        }
        
        // Sinon, on le charge
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(getClass().getResource(nomFXML));
            Scene scene = new Scene(loader.load());
            
            // On le stocke pour ne pas le recharger
            scenes.put(nomEcran, scene);
            
            // On donne la référence au contrôleur (s'il en a besoin)
            Object controller = loader.getController();
            
            if (controller instanceof AccueilController) {
                ((AccueilController) controller).setNavigationManager(this);
            } else if (controller instanceof ProfilController) {
                ((ProfilController) controller).setNavigationManager(this);
            } else if (controller instanceof ParametresController) {
                ((ParametresController) controller).setNavigationManager(this);
            } else if (controller instanceof AProposController) {
                ((AProposController) controller).setNavigationManager(this);
            }
            
            return scene;
            
        } catch (Exception e) {
            System.err.println("Erreur lors du chargement de " + nomFXML);
            e.printStackTrace();
            return null;
        }
    }
    
    // Méthodes publiques pour afficher chaque écran
    public void afficherAccueil() {
        Scene scene = chargerScene("accueil.fxml", "accueil");
        if (scene != null) {
            stage.setScene(scene);
        }
    }
    
    public void afficherProfil() {
        Scene scene = chargerScene("profil.fxml", "profil");
        if (scene != null) {
            stage.setScene(scene);
        }
    }
    
    public void afficherParametres() {
        Scene scene = chargerScene("parametres.fxml", "parametres");
        if (scene != null) {
            stage.setScene(scene);
        }
    }
    
    public void afficherAPropos() {
        Scene scene = chargerScene("aPropos.fxml", "aPropos");
        if (scene != null) {
            stage.setScene(scene);
        }
    }
}

