package application;

import javafx.fxml.FXML;

public class ProfilController {
    
    private NavigationManager navigationManager;
    
    // Méthode appelée quand on clique sur "Retour à l'accueil"
    @FXML
    private void retourAccueil() {
        if (navigationManager != null) {
            navigationManager.afficherAccueil();
        }
    }
    
    // Méthode appelée quand on clique sur "Paramètres"
    @FXML
    private void allerAuxParametres() {
        if (navigationManager != null) {
            navigationManager.afficherParametres();
        }
    }
    
    // Méthode appelée quand on clique sur "À propos"
    @FXML
    private void allerAAPropos() {
        if (navigationManager != null) {
            navigationManager.afficherAPropos();
        }
    }
    
    // NavigationManager appelle cette méthode pour se connecter
    public void setNavigationManager(NavigationManager navigationManager) {
        this.navigationManager = navigationManager;
    }
}

